/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.interceptor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import hu.icellmobilsoft.coffee.cdi.logger.AppLogger;
import hu.icellmobilsoft.coffee.cdi.logger.ThisLogger;
import hu.icellmobilsoft.coffee.dto.common.Envelope;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.module.redis.annotation.RedisConnection;
import hu.icellmobilsoft.coffee.module.redis.interceptor.annotation.RedisCached;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManager;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManagerConnection;
import hu.icellmobilsoft.coffee.tool.gson.ClassTypeAdapter;
import hu.icellmobilsoft.coffee.tool.gson.JsonUtil;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

@Interceptor
@RedisCached
public class RedisCachingInterceptor {
    @Inject
    @ThisLogger
    private AppLogger log;
    private Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (Object)new ClassTypeAdapter()).create();

    @AroundInvoke
    public Object perform(InvocationContext ctx) throws Exception {
        return this.getReturnOfCache(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getReturnOfCache(InvocationContext ctx) throws Exception {
        RedisManager redisManager = this.getRedisManager(ctx.getMethod());
        String key = this.getKey(ctx.getMethod(), ctx.getParameters());
        try {
            Object objectToReturn;
            RedisManagerConnection ignored;
            block22: {
                Optional json;
                block21: {
                    ignored = redisManager.initConnection();
                    try {
                        json = redisManager.run(Jedis::get, "get", key);
                        if (!json.isEmpty()) break block21;
                        this.log.debug("Data is not cached in Redis, caching key: [{0}]", new Object[]{key});
                        Object objectToReturn2 = ctx.proceed();
                        long timeToExpire = this.getTime(ctx.getMethod());
                        Envelope envelope = new Envelope(this.gson.toJson(objectToReturn2), objectToReturn2.getClass());
                        Optional statusCode = redisManager.run(Jedis::setex, "setex", key, timeToExpire, JsonUtil.toJsonEx((Object)envelope));
                        if (statusCode.isPresent() && !StringUtils.equals((CharSequence)((CharSequence)statusCode.get()), (CharSequence)"OK")) {
                            this.log.warn("Problems in recording cache - status code [{0}]", new Object[]{statusCode});
                        }
                        Object object = objectToReturn2;
                        if (ignored != null) {
                            ignored.close();
                        }
                        return object;
                    }
                    catch (Throwable throwable) {
                        Object object;
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonSyntaxException e) {
                            this.log.error("Syntax problem, removing the key!", (Throwable)e);
                            redisManager.run(Jedis::del, "del", key);
                            object = ctx.proceed();
                            return object;
                        }
                        catch (Exception e) {
                            this.log.error("Exception on Redis [{0}]", new Object[]{e.getMessage(), e});
                            object = ctx.proceed();
                            return object;
                        }
                    }
                }
                Envelope envelope = (Envelope)this.gson.fromJson((String)json.get(), Envelope.class);
                Class type = envelope.getTypeOfJson();
                objectToReturn = this.gson.fromJson(envelope.getJson(), type);
                if (objectToReturn != null) break block22;
                this.log.warn("Problems with the object type - Type Envelop [{0}]", new Object[]{type});
                Object object = ctx.proceed();
                if (ignored != null) {
                    ignored.close();
                }
                return object;
            }
            this.log.debug("Data from Redis: [{0}]", new Object[]{objectToReturn});
            Object object = objectToReturn;
            if (ignored != null) {
                ignored.close();
            }
            return object;
        }
        finally {
            CDI.current().destroy((Object)redisManager);
        }
    }

    private RedisManager getRedisManager(Method method) throws BaseException {
        RedisConnection redisConnection = method.getAnnotation(RedisConnection.class);
        if (redisConnection == null) {
            redisConnection = method.getDeclaringClass().getAnnotation(RedisConnection.class);
        }
        if (redisConnection != null) {
            String configKey = redisConnection.configKey();
            String poolConfigKey = redisConnection.poolConfigKey();
            return (RedisManager)CDI.current().select(RedisManager.class, new Annotation[]{new RedisConnection.Literal(configKey, poolConfigKey)}).get();
        }
        throw new BaseException(MessageFormat.format("@RedisConnection annotation is missing from method: {0}#{1}", method.getDeclaringClass().getCanonicalName(), method.getName()));
    }

    private long getTime(Method method) {
        RedisCached enableCaching = method.getAnnotation(RedisCached.class);
        if (enableCaching == null) {
            enableCaching = method.getDeclaringClass().getAnnotation(RedisCached.class);
        }
        return enableCaching.expireInSeconds();
    }

    private String getKey(Method method, Object[] parameters) {
        String parametersInLineCustom = Arrays.toString(parameters).replace(" ", "").replace("null", "");
        return method.getDeclaringClass().getSimpleName() + method.getName() + parametersInLineCustom;
    }
}

