/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.manager;

import hu.icellmobilsoft.coffee.cdi.trace.annotation.Traced;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.redis.annotation.RedisConnection;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManagerConnection;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.common.FunctionalInterfaces;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

@Dependent
public class RedisManager {
    private static final String JEDIS_NOT_INITIALIZED_MSG = "jedis is not initialized";
    @Inject
    private Logger log;
    private String configKey;
    private String poolConfigKey;
    private Instance<Jedis> jedisInstance;
    private Jedis jedis;

    protected void logEnter(String functionName, Object ... params) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(">>" + this.getCalledMethodWithParamsType(functionName, params));
        }
    }

    protected void logReturn(String functionName, Object ... params) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("<<" + this.getCalledMethodWithParamsType(functionName, params));
        }
    }

    protected String getCalledMethodWithParamsType(String functionName, Object ... params) {
        StringBuilder functionInfo = new StringBuilder(" ").append(functionName).append("(");
        int index = 0;
        if (params != null) {
            for (Object param : params) {
                if (index > 0) {
                    functionInfo.append(", ");
                }
                if (param != null) {
                    functionInfo.append(param.getClass().getTypeName());
                } else {
                    functionInfo.append(param);
                }
                ++index;
            }
        }
        return functionInfo.append(")").toString();
    }

    protected TechnicalException repositoryFailed(Exception e, String functionInfo) {
        String message = "Error occurred when calling redis operation " + functionInfo + " : [" + e.getLocalizedMessage() + "]";
        return new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, message, (Throwable)e);
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <R> Optional<R> run(FunctionalInterfaces.BaseExceptionFunction<Jedis, R> function, String functionName) throws BaseException {
        if (this.jedis == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, JEDIS_NOT_INITIALIZED_MSG);
        }
        this.logEnter(functionName, new Object[0]);
        try {
            Object response = function.apply((Object)this.jedis);
            this.logReturn(functionName, new Object[0]);
            return Optional.ofNullable(response);
        }
        catch (Exception e) {
            throw this.repositoryFailed(e, functionName);
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, R> Optional<R> run(FunctionalInterfaces.BaseExceptionFunction2<Jedis, P1, R> function, String functionName, P1 p1) throws BaseException {
        if (this.jedis == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, JEDIS_NOT_INITIALIZED_MSG);
        }
        this.logEnter(functionName, p1);
        if (this.isNullOrBlankAnyParameter(p1)) {
            throw this.newInvalidParameterException(functionName);
        }
        try {
            Object response = function.apply((Object)this.jedis, p1);
            this.logReturn(functionName, p1);
            return Optional.ofNullable(response);
        }
        catch (Exception e) {
            throw this.repositoryFailed(e, functionName);
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, R> Optional<R> run(FunctionalInterfaces.BaseExceptionFunction3<Jedis, P1, P2, R> function, String functionName, P1 p1, P2 p2) throws BaseException {
        if (this.jedis == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, JEDIS_NOT_INITIALIZED_MSG);
        }
        this.logEnter(functionName, p1, p2);
        if (this.isNullOrBlankAnyParameter(p1, p2)) {
            throw this.newInvalidParameterException(functionName);
        }
        try {
            Object response = function.apply((Object)this.jedis, p1, p2);
            this.logReturn(functionName, p1, p2);
            return Optional.ofNullable(response);
        }
        catch (Exception e) {
            throw this.repositoryFailed(e, functionName);
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, P3, R> Optional<R> run(FunctionalInterfaces.BaseExceptionFunction4<Jedis, P1, P2, P3, R> function, String functionName, P1 p1, P2 p2, P3 p3) throws BaseException {
        if (this.jedis == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, JEDIS_NOT_INITIALIZED_MSG);
        }
        this.logEnter(functionName, p1, p2, p3);
        if (this.isNullOrBlankAnyParameter(p1, p2, p3)) {
            throw this.newInvalidParameterException(functionName);
        }
        try {
            Object response = function.apply((Object)this.jedis, p1, p2, p3);
            this.logReturn(functionName, p1, p2, p3);
            return Optional.ofNullable(response);
        }
        catch (Exception e) {
            throw this.repositoryFailed(e, functionName);
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, P3, P4, R> Optional<R> run(FunctionalInterfaces.BaseExceptionFunction5<Jedis, P1, P2, P3, P4, R> function, String functionName, P1 p1, P2 p2, P3 p3, P4 p4) throws BaseException {
        if (this.jedis == null) {
            throw new TechnicalException((Enum)CoffeeFaultType.REDIS_OPERATION_FAILED, JEDIS_NOT_INITIALIZED_MSG);
        }
        this.logEnter(functionName, p1, p2, p3, p4);
        if (this.isNullOrBlankAnyParameter(p1, p2, p3, p4)) {
            throw this.newInvalidParameterException(functionName);
        }
        try {
            Object response = function.apply((Object)this.jedis, p1, p2, p3, p4);
            this.logReturn(functionName, p1, p2, p3, p4);
            return Optional.ofNullable(response);
        }
        catch (Exception e) {
            throw this.repositoryFailed(e, functionName);
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <R> Optional<R> runWithConnection(FunctionalInterfaces.BaseExceptionFunction<Jedis, R> function, String functionName) throws BaseException {
        try (RedisManagerConnection ignored = this.initConnection();){
            Optional<R> optional = this.run(function, functionName);
            return optional;
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, R> Optional<R> runWithConnection(FunctionalInterfaces.BaseExceptionFunction2<Jedis, P1, R> function, String functionName, P1 p1) throws BaseException {
        try (RedisManagerConnection ignored = this.initConnection();){
            Optional<R> optional = this.run(function, functionName, p1);
            return optional;
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, R> Optional<R> runWithConnection(FunctionalInterfaces.BaseExceptionFunction3<Jedis, P1, P2, R> function, String functionName, P1 p1, P2 p2) throws BaseException {
        try (RedisManagerConnection ignored = this.initConnection();){
            Optional<R> optional = this.run(function, functionName, p1, p2);
            return optional;
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, P3, R> Optional<R> runWithConnection(FunctionalInterfaces.BaseExceptionFunction4<Jedis, P1, P2, P3, R> function, String functionName, P1 p1, P2 p2, P3 p3) throws BaseException {
        try (RedisManagerConnection ignored = this.initConnection();){
            Optional<R> optional = this.run(function, functionName, p1, p2, p3);
            return optional;
        }
    }

    @Traced(component="jedis", kind="CLIENT", dbType="redis")
    public <P1, P2, P3, P4, R> Optional<R> runWithConnection(FunctionalInterfaces.BaseExceptionFunction5<Jedis, P1, P2, P3, P4, R> function, String functionName, P1 p1, P2 p2, P3 p3, P4 p4) throws BaseException {
        try (RedisManagerConnection ignored = this.initConnection();){
            Optional<R> optional = this.run(function, functionName, p1, p2, p3, p4);
            return optional;
        }
    }

    public RedisManagerConnection initConnection() {
        if (this.jedisInstance == null) {
            this.jedisInstance = CDI.current().select(Jedis.class, new Annotation[]{new RedisConnection.Literal(this.configKey, this.poolConfigKey)});
        }
        if (this.jedis == null) {
            this.jedis = (Jedis)this.jedisInstance.get();
        }
        return new RedisManagerConnection(this);
    }

    public void closeConnection() {
        if (this.jedis != null) {
            this.jedisInstance.destroy((Object)this.jedis);
            this.jedis = null;
        }
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setPoolConfigKey(String poolConfigKey) {
        this.poolConfigKey = poolConfigKey;
    }

    private BaseException newInvalidParameterException(String functionName) {
        return new InvalidParameterException("At least one incoming parameter in " + functionName + " is null or blank!");
    }

    private boolean isNullOrBlankAnyParameter(Object ... params) {
        for (Object param : params) {
            if (param != null && (!(param instanceof String) || !StringUtils.isBlank((CharSequence)((String)param)))) continue;
            return true;
        }
        return false;
    }
}

