/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.manager.producer;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.module.redis.annotation.RedisConnection;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManager;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.annotation.AnnotationUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class RedisManagerProducer {
    @Inject
    private Logger log;

    @Dependent
    @Produces
    @RedisConnection(configKey="", poolConfigKey="")
    public RedisManager getRedisService(InjectionPoint injectionPoint) throws BaseException {
        Optional annotation = AnnotationUtil.getAnnotation((InjectionPoint)injectionPoint, RedisConnection.class);
        String configKey = annotation.map(RedisConnection::configKey).orElse(null);
        String poolConfigKey = annotation.map(RedisConnection::poolConfigKey).orElse("default");
        if (StringUtils.isBlank((CharSequence)configKey)) {
            throw new IllegalStateException("configKey is required for redis");
        }
        this.log.trace("Creating RedisManager with configKey: [{0}]", new Object[]{configKey});
        RedisManager redisManager = (RedisManager)CDI.current().select(RedisManager.class, new Annotation[0]).get();
        redisManager.setConfigKey(configKey);
        redisManager.setPoolConfigKey(poolConfigKey);
        return redisManager;
    }

    public void returnResource(@Disposes @RedisConnection(configKey="", poolConfigKey="") RedisManager redisManager) {
        if (Objects.nonNull(redisManager)) {
            CDI.current().destroy((Object)redisManager);
        }
    }
}

