/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.producer;

import hu.icellmobilsoft.coffee.cdi.metric.spi.IJedisMetricsHandler;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.module.redis.annotation.RedisConnection;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.annotation.AnnotationUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Optional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

@ApplicationScoped
public class JedisConnectionProducer {
    @Inject
    private Logger log;
    @Inject
    private IJedisMetricsHandler jedisMetricsHandler;

    @Produces
    @Dependent
    @RedisConnection(configKey="", poolConfigKey="")
    public Jedis getJedis(InjectionPoint injectionPoint) throws BaseException {
        Optional annotation = AnnotationUtil.getAnnotation((InjectionPoint)injectionPoint, RedisConnection.class);
        String configKey = annotation.map(RedisConnection::configKey).orElse(null);
        String poolConfigKey = annotation.map(RedisConnection::poolConfigKey).orElse("default");
        Instance jedisPoolInstance = CDI.current().select(JedisPool.class, new Annotation[]{new RedisConnection.Literal(configKey, poolConfigKey)});
        JedisPool jedisPool = (JedisPool)jedisPoolInstance.get();
        if (jedisPool != null) {
            try {
                this.jedisMetricsHandler.addMetric(configKey, poolConfigKey, () -> ((JedisPool)jedisPool).getNumActive(), () -> ((JedisPool)jedisPool).getNumIdle());
                Jedis jedis = jedisPool.getResource();
                return jedis;
            }
            catch (JedisConnectionException ex) {
                String msg = MessageFormat.format("Problems trying to get the Redis connection for the configKey:[{0}], poolConfigKey:[{1}]", configKey, poolConfigKey);
                this.log.error(msg, (Throwable)ex);
                throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg, (Throwable)ex);
            }
            finally {
                jedisPoolInstance.destroy((Object)jedisPool);
            }
        }
        String msg = MessageFormat.format("Could not create Redis connection for the configKey:[{0}], poolConfigKey:[{1}]! Jedis pool is null", configKey, poolConfigKey);
        throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, msg);
    }

    public void returnResource(@Disposes @RedisConnection(configKey="", poolConfigKey="") Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }
}

