/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redis.producer;

import hu.icellmobilsoft.coffee.module.redis.annotation.RedisConnection;
import hu.icellmobilsoft.coffee.module.redis.config.ManagedRedisConfig;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.annotation.AnnotationUtil;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@ApplicationScoped
public class JedisPoolProducer {
    public static final String DELIMITER = "_";
    @Inject
    private Logger log;
    private Map<String, JedisPool> jedisPoolInstances = new HashMap<String, JedisPool>();

    @Produces
    @Dependent
    @RedisConnection(configKey="", poolConfigKey="")
    public JedisPool getJedisPool(InjectionPoint injectionPoint) {
        Optional annotation = AnnotationUtil.getAnnotation((InjectionPoint)injectionPoint, RedisConnection.class);
        String configKey = annotation.map(RedisConnection::configKey).orElse(null);
        String poolConfigKey = annotation.map(RedisConnection::poolConfigKey).orElse("default");
        return this.getInstance(configKey, poolConfigKey);
    }

    private synchronized JedisPool getInstance(String configKey, String poolConfigKey) {
        return this.jedisPoolInstances.computeIfAbsent(configKey + DELIMITER + poolConfigKey, v -> this.createJedisPool(configKey, poolConfigKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JedisPool createJedisPool(String configKey, String poolConfigKey) {
        this.log.info("Creating JedisPool for configKey:[{0}]", new Object[]{configKey});
        Instance instance = CDI.current().select(ManagedRedisConfig.class, new Annotation[]{new RedisConnection.Literal(configKey, poolConfigKey)});
        ManagedRedisConfig managedRedisConfig = (ManagedRedisConfig)instance.get();
        try {
            String host = managedRedisConfig.getHost();
            int port = managedRedisConfig.getPort();
            int database = managedRedisConfig.getDatabase();
            this.log.info("Redis host [{0}], port: [{1}], database: [{2}], poolConfigKey: [{3}]", new Object[]{host, port, database, poolConfigKey});
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(managedRedisConfig.getPoolMaxTotal().intValue());
            poolConfig.setMaxIdle(managedRedisConfig.getPoolMaxIdle().intValue());
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, managedRedisConfig.getTimeout().intValue(), managedRedisConfig.getPassword(), database);
            return jedisPool;
        }
        catch (Exception e) {
            this.log.error(MessageFormat.format("Exception on initializing JedisPool for configKey [{0}], poolConfigKey [{1}]: [{2}]", configKey, poolConfigKey, e.getLocalizedMessage()), (Throwable)e);
            JedisPool jedisPool = null;
            return jedisPool;
        }
        finally {
            instance.destroy((Object)managedRedisConfig);
        }
    }

    @PreDestroy
    public void clear() {
        for (JedisPool jedisPool : this.jedisPoolInstances.values()) {
            if (jedisPool.isClosed()) continue;
            jedisPool.destroy();
        }
        this.jedisPoolInstances.clear();
    }
}

