/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.annotation;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Qualifier
public @interface RedisStreamConsumer {
    public static final AnnotationLiteral<RedisStreamConsumer> LITERAL = new Literal("", "", 0, 0);

    @Nonbinding
    public String configKey();

    @Nonbinding
    public String group();

    @Nonbinding
    public int consumerThreadsCount() default 1;

    @Nonbinding
    public int retryCount() default 1;

    public static final class Literal
    extends AnnotationLiteral<RedisStreamConsumer>
    implements RedisStreamConsumer {
        private static final long serialVersionUID = 1L;
        final String configKey;
        final String group;
        final int consumerThreadsCount;
        final int retryCount;

        public Literal(String configKey, String group, int consumerThreadsCount, int retryCount) {
            this.configKey = configKey;
            this.group = group;
            this.consumerThreadsCount = consumerThreadsCount;
            this.retryCount = retryCount;
        }

        @Override
        @Nonbinding
        public String configKey() {
            return this.configKey;
        }

        @Override
        @Nonbinding
        public String group() {
            return this.group;
        }

        @Override
        @Nonbinding
        public int consumerThreadsCount() {
            return this.consumerThreadsCount;
        }

        @Override
        @Nonbinding
        public int retryCount() {
            return this.retryCount;
        }
    }
}

