/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.bootstrap;

import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

@ApplicationScoped
public class ConsumerLifeCycleManager {
    public static boolean ENDLOOP;
    public static final AtomicInteger CONSUMER_COUNTER;
    public static final Semaphore SEMAPHORE;
    @Inject
    private Logger log;

    public void stop(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object init) {
        this.log.info("Initiate shutdown stopping consumers");
        int consumerCount = CONSUMER_COUNTER.get();
        this.log.info("Stopping redis consumers, count: [{0}]", new Object[]{consumerCount});
        ConsumerLifeCycleManager.stopLoop();
        if (consumerCount < 1) {
            return;
        }
        try {
            SEMAPHORE.acquire();
            this.log.info("Redis consumers stopped");
        }
        catch (InterruptedException e) {
            this.log.error("Error occured while waiting for consumers to finish while shutting down", (Throwable)e);
        }
    }

    public static void stopLoop() {
        ENDLOOP = true;
    }

    static {
        CONSUMER_COUNTER = new AtomicInteger(0);
        SEMAPHORE = new Semaphore(0);
    }
}

