/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.config;

import hu.icellmobilsoft.coffee.module.redisstream.config.IStreamGroupConfig;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

@Dependent
public class StreamGroupConfig
implements IStreamGroupConfig {
    public static final String KEY_DELIMITER = ".";
    public static final String REDISSTREAM_PREFIX = "coffee.redisstream";
    public static final String PRODUCER_MAXLEN = "producer.maxlen";
    public static final String PRODUCER_TTL = "producer.ttl";
    public static final String STREAM_READ_TIMEOUTMILLIS = "stream.read.timeoutmillis";
    public static final String CONSUMER_THREADS_COUNT = "consumer.threadsCount";
    public static final String RETRY_COUNT = "consumer.retryCount";
    public static final String MANUAL_ACK = "consumer.manualAck";
    public static final String ENABLED = "enabled";
    @Inject
    private Config config;
    private String configKey;

    @Override
    public Optional<Long> getProducerMaxLen() {
        return this.config.getOptionalValue(this.joinKey(PRODUCER_MAXLEN), Long.class);
    }

    @Override
    public Optional<Long> getProducerTTL() {
        return this.config.getOptionalValue(this.joinKey(PRODUCER_TTL), Long.class);
    }

    @Override
    public Long getStreamReadTimeoutMillis() {
        return this.config.getOptionalValue(this.joinKey(STREAM_READ_TIMEOUTMILLIS), Long.class).orElse(Duration.ofMinutes(1L).toMillis());
    }

    @Override
    public Optional<Integer> getConsumerThreadsCount() {
        return this.config.getOptionalValue(this.joinKey(CONSUMER_THREADS_COUNT), Integer.class);
    }

    @Override
    public Optional<Integer> getRetryCount() {
        return this.config.getOptionalValue(this.joinKey(RETRY_COUNT), Integer.class);
    }

    @Override
    public boolean isEnabled() {
        return this.config.getOptionalValue(this.joinKey(ENABLED), Boolean.class).orElse(true);
    }

    @Override
    public boolean isManualAck() {
        return this.config.getOptionalValue(this.joinKey(MANUAL_ACK), Boolean.class).orElse(false);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    private String joinKey(String key) {
        return String.join((CharSequence)KEY_DELIMITER, REDISSTREAM_PREFIX, this.getConfigKey(), key);
    }
}

