/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.consumer;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.rest.cdi.BaseApplicationContainer;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDC;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import redis.clients.jedis.resps.StreamEntry;

public class BaseStreamConsumer {
    @Inject
    private Logger log;
    @Inject
    private BaseApplicationContainer baseApplicationContainer;

    protected void handleMDC(StreamEntry streamEntry) {
        MDC.put((String)"serviceName", (String)this.baseApplicationContainer.getCoffeeAppName());
        int retryCount = NumberUtils.toInt((String)MDC.get((String)"retryCounter"));
        MDC.put((String)"retryCounter", (String)String.valueOf(retryCount + 1));
    }

    protected boolean customize(StreamEntry streamEntry) throws BaseException {
        return this.isExpiredTtl(streamEntry);
    }

    protected boolean isExpiredTtl(StreamEntry streamEntry) throws BaseException {
        Map fieldMap = streamEntry.getFields();
        String ttl = (String)fieldMap.get("ttl");
        if (StringUtils.isNotBlank((CharSequence)ttl)) {
            try {
                LocalDateTime ttlDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(ttl)), ZoneId.systemDefault());
                if (ttlDate.isBefore(LocalDateTime.now())) {
                    this.log.trace("Message [{0}] with ttl [{1}] exceeded.", new Object[]{streamEntry.getID(), ttl});
                    return true;
                }
            }
            catch (NumberFormatException e) {
                this.log.trace("Cant parse message [{0}] with ttl [{1}] value, skipping ttl check. Error: [{2}]", new Object[]{streamEntry.getID(), ttl, e.getLocalizedMessage()});
            }
        }
        return false;
    }
}

