/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.publisher;

import hu.icellmobilsoft.coffee.module.redisstream.config.StreamMessageParameter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

public class RedisStreamPublication {
    private final String streamGroup;
    private final String streamMessage;
    private Map<String, String> parameters;

    public static RedisStreamPublication of(String streamGroup, String streamMessage) {
        return RedisStreamPublication.of(streamGroup, streamMessage, null);
    }

    public static RedisStreamPublication of(String streamMessage) {
        return RedisStreamPublication.of(null, streamMessage, null);
    }

    public static RedisStreamPublication of(String streamMessage, Map<String, String> parameters) {
        return RedisStreamPublication.of(null, streamMessage, parameters);
    }

    public RedisStreamPublication withTTL(long expiryInSec) {
        this.withParameter(StreamMessageParameter.TTL, (Object)Instant.now().plus(expiryInSec, ChronoUnit.SECONDS).toEpochMilli());
        return this;
    }

    public RedisStreamPublication withParameter(StreamMessageParameter parameterKey, Object parameterValue) {
        this.getInitializedParameters().put(parameterKey.getMessageKey(), String.valueOf(parameterValue));
        return this;
    }

    public RedisStreamPublication withParameter(String parameterKey, Object parameterValue) {
        this.getInitializedParameters().put(parameterKey, String.valueOf(parameterValue));
        return this;
    }

    private Map<String, String> getInitializedParameters() {
        if (this.getParameters() == null) {
            this.parameters = new HashMap<String, String>();
        }
        return this.getParameters();
    }

    public static RedisStreamPublication of(String streamGroup, String streamMessage, Map<String, String> parameters) {
        return new RedisStreamPublication(streamGroup, streamMessage, parameters);
    }

    private RedisStreamPublication(String streamGroup, String streamMessage, Map<String, String> parameters) {
        this.streamGroup = streamGroup;
        this.streamMessage = streamMessage;
        this.parameters = parameters;
    }

    public String getStreamGroup() {
        return this.streamGroup;
    }

    public String getStreamMessage() {
        return this.streamMessage;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

