/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.redisstream.publisher;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManager;
import hu.icellmobilsoft.coffee.module.redis.manager.RedisManagerConnection;
import hu.icellmobilsoft.coffee.module.redisstream.common.RedisStreamUtil;
import hu.icellmobilsoft.coffee.module.redisstream.config.StreamGroupConfig;
import hu.icellmobilsoft.coffee.module.redisstream.config.StreamMessageParameter;
import hu.icellmobilsoft.coffee.module.redisstream.publisher.RedisStreamPublication;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDC;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.commands.StreamCommands;
import redis.clients.jedis.params.XAddParams;

@Dependent
public class RedisStreamPublisher {
    @Inject
    private Logger log;
    @Inject
    private StreamGroupConfig config;
    private RedisManager redisManager;
    private String streamGroup;

    public void init(RedisManager redisManager, String streamGroup) {
        this.redisManager = redisManager;
        this.streamGroup = streamGroup;
        this.config.setConfigKey(streamGroup);
    }

    public Optional<StreamEntryID> publish(String streamMessage) throws BaseException {
        return this.publish(streamMessage, (Map<String, String>)null);
    }

    public Optional<StreamEntryID> publish(String streamMessage, Map<String, String> parameters) throws BaseException {
        this.checkInitialization();
        return this.publishInNewConnection(this.streamGroup, streamMessage, parameters);
    }

    public Optional<StreamEntryID> publish(String streamGroup, String streamMessage) throws BaseException {
        return this.publish(streamGroup, streamMessage, null);
    }

    public Optional<StreamEntryID> publish(String streamGroup, String streamMessage, Map<String, String> parameters) throws BaseException {
        this.checkRedisManager();
        this.validateGroup(streamGroup);
        return this.publishInNewConnection(streamGroup, streamMessage, parameters);
    }

    public Optional<StreamEntryID> publishPublication(RedisStreamPublication publication) throws BaseException {
        if (publication == null) {
            throw new InvalidParameterException("publication is null!");
        }
        this.checkRedisManager();
        if (StringUtils.isBlank((CharSequence)publication.getStreamGroup())) {
            this.validateGroup(this.streamGroup);
            return this.publishInNewConnection(this.streamGroup, publication.getStreamMessage(), publication.getParameters());
        }
        return this.publishInNewConnection(publication.getStreamGroup(), publication.getStreamMessage(), publication.getParameters());
    }

    public List<Optional<StreamEntryID>> publishPublications(List<RedisStreamPublication> publications) throws BaseException {
        if (publications == null) {
            throw new InvalidParameterException("publications is null!");
        }
        this.checkRedisManager();
        try (RedisManagerConnection ignored = this.redisManager.initConnection();){
            ArrayList<Optional<StreamEntryID>> ids = new ArrayList<Optional<StreamEntryID>>(publications.size());
            for (RedisStreamPublication publication : publications) {
                Optional<StreamEntryID> id;
                if (StringUtils.isBlank((CharSequence)publication.getStreamGroup())) {
                    this.validateGroup(this.streamGroup);
                    id = this.publishInActiveConnection(this.createJedisMessage(publication.getStreamMessage(), publication.getParameters()), this.streamGroup);
                } else {
                    id = this.publishInActiveConnection(this.createJedisMessage(publication.getStreamMessage(), publication.getParameters()), publication.getStreamGroup());
                }
                ids.add(id);
            }
            ArrayList<Optional<StreamEntryID>> arrayList = ids;
            return arrayList;
        }
    }

    public List<Optional<StreamEntryID>> publish(List<String> streamMessages) throws BaseException {
        return this.publish(streamMessages, null);
    }

    public List<Optional<StreamEntryID>> publish(List<String> streamMessages, Map<String, String> parameters) throws BaseException {
        if (streamMessages == null) {
            throw new InvalidParameterException("streamMessages is null!");
        }
        this.checkInitialization();
        try (RedisManagerConnection ignored = this.redisManager.initConnection();){
            List<Optional<StreamEntryID>> list = this.publishInActiveConnection(this.streamGroup, streamMessages, parameters);
            return list;
        }
    }

    public List<Optional<StreamEntryID>> publish(String streamGroup, List<String> streamMessages) throws BaseException {
        return this.publish(streamGroup, streamMessages, null);
    }

    public List<Optional<StreamEntryID>> publish(String streamGroup, List<String> streamMessages, Map<String, String> parameters) throws BaseException {
        if (streamMessages == null) {
            throw new InvalidParameterException("streamMessages is null!");
        }
        this.validateGroup(streamGroup);
        this.checkRedisManager();
        try (RedisManagerConnection ignored = this.redisManager.initConnection();){
            List<Optional<StreamEntryID>> list = this.publishInActiveConnection(streamGroup, streamMessages, parameters);
            return list;
        }
    }

    protected List<Optional<StreamEntryID>> publishInActiveConnection(String streamGroup, List<String> streamMessages, Map<String, String> parameters) throws BaseException {
        ArrayList<Optional<StreamEntryID>> ids = new ArrayList<Optional<StreamEntryID>>(streamMessages.size());
        for (String streamMessage : streamMessages) {
            Optional<StreamEntryID> id = this.publishInActiveConnection(this.createJedisMessage(streamMessage, parameters), streamGroup);
            ids.add(id);
        }
        return ids;
    }

    protected Optional<StreamEntryID> publishInNewConnection(String streamGroup, String streamMessage, Map<String, String> parameters) throws BaseException {
        try (RedisManagerConnection ignored = this.redisManager.initConnection();){
            Optional<StreamEntryID> optional = this.publishInActiveConnection(this.createJedisMessage(streamMessage, parameters), streamGroup);
            return optional;
        }
    }

    protected Map<String, String> createJedisMessage(String streamMessage, Map<String, String> parameters) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("extSessionId", this.getFlowIdMessage(parameters));
        keyValues.put("message", streamMessage);
        if (parameters != null) {
            keyValues.putAll(parameters);
        }
        return keyValues;
    }

    private String getFlowIdMessage(Map<String, String> parameters) {
        String flowIdMessage = MDC.get((String)"extSessionId");
        if (parameters == null) {
            return flowIdMessage;
        }
        return Optional.ofNullable(parameters.get(StreamMessageParameter.FLOW_ID_EXTENSION.getMessageKey())).map(extension -> flowIdMessage + "_" + extension).orElse(flowIdMessage);
    }

    protected Optional<StreamEntryID> publishInActiveConnection(Map<String, String> values, String streamGroup) throws BaseException {
        XAddParams params = XAddParams.xAddParams();
        this.config.getProducerMaxLen().ifPresent(arg_0 -> ((XAddParams)params).maxLen(arg_0));
        this.config.getProducerTTL().ifPresent(ttl -> params.minId(new StreamEntryID(Instant.now().minusMillis((long)ttl).toEpochMilli(), 0L).toString()));
        Optional streamEntryID = this.redisManager.run(StreamCommands::xadd, "xadd", (Object)RedisStreamUtil.streamKey(streamGroup), values, (Object)params);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Published streamEntryID: [{0}] into [{1}]", new Object[]{streamEntryID, RedisStreamUtil.streamKey(streamGroup)});
        }
        return streamEntryID;
    }

    public static Map.Entry<String, String> parameterOf(StreamMessageParameter parameterKey, Object parameterValue) throws BaseException {
        if (parameterKey == null) {
            throw new InvalidParameterException("parameterKey is null!");
        }
        return Map.entry(parameterKey.getMessageKey(), String.valueOf(parameterValue));
    }

    protected void validateGroup(String streamGroup) throws TechnicalException {
        if (StringUtils.isBlank((CharSequence)streamGroup)) {
            throw new InvalidParameterException("Input of custom streamGroup is null!");
        }
    }

    protected void checkInitialization() throws BaseException {
        if (this.redisManager == null || this.streamGroup == null) {
            throw this.notInitializedException();
        }
    }

    protected void checkRedisManager() throws TechnicalException {
        if (this.redisManager == null) {
            throw this.notInitializedException();
        }
    }

    private TechnicalException notInitializedException() {
        return new TechnicalException("RedisStreamHandler is not initialized!");
    }
}

