/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.se.logging;

import hu.icellmobilsoft.coffee.se.logging.JulLevel;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DefaultLogger
implements Logger {
    private java.util.logging.Logger logger;

    private DefaultLogger() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return DefaultLogger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        DefaultLogger appLogger = new DefaultLogger();
        appLogger.setLogger(java.util.logging.Logger.getLogger(name));
        return appLogger;
    }

    @Override
    public void setLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public java.util.logging.Logger getLogger() {
        return this.logger;
    }

    private java.util.logging.Logger logger() {
        if (this.getLogger() == null) {
            java.util.logging.Logger log = java.util.logging.Logger.getLogger(this.getClass().getName());
            log.log((Level)JulLevel.WARN, "Logger not SET! Applogger create temporary logger!");
            return log;
        }
        return this.logger;
    }

    @Override
    public void trace(String msg) {
        this.logger().log((Level)JulLevel.TRACE, msg);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logger().log((Level)JulLevel.TRACE, () -> MessageFormat.format(format, arguments));
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger().log((Level)JulLevel.TRACE, msg, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger().isLoggable(JulLevel.TRACE);
    }

    @Override
    public void debug(String msg) {
        this.logger().log((Level)JulLevel.DEBUG, msg);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logger().log((Level)JulLevel.DEBUG, () -> MessageFormat.format(format, arguments));
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger().log((Level)JulLevel.DEBUG, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger().isLoggable(JulLevel.DEBUG);
    }

    @Override
    public void info(String msg) {
        this.logger().log((Level)JulLevel.INFO, msg);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logger().log((Level)JulLevel.INFO, () -> MessageFormat.format(format, arguments));
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger().log((Level)JulLevel.INFO, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger().isLoggable(JulLevel.INFO);
    }

    @Override
    public void warn(String msg) {
        this.logger().log((Level)JulLevel.WARN, msg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logger().log((Level)JulLevel.WARN, () -> MessageFormat.format(format, arguments));
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger().log((Level)JulLevel.WARN, msg, t);
    }

    @Override
    public void error(String msg) {
        this.logger().log((Level)JulLevel.ERROR, msg);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logger().log((Level)JulLevel.ERROR, () -> MessageFormat.format(format, arguments));
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger().log((Level)JulLevel.ERROR, msg, t);
    }
}

