/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.se.logging.mdc;

import hu.icellmobilsoft.coffee.se.logging.DefaultLogger;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDCAdapter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class JbossMDCAdapter
implements MDCAdapter {
    private Logger log = DefaultLogger.getLogger(JbossMDCAdapter.class);
    private Method put;
    private Method get;
    private Method getMap;
    private Method clear;
    private Method remove;

    public JbossMDCAdapter() throws Exception {
        Class<?> jbossMDC = Class.forName("org.jboss.logging.MDC");
        this.put = jbossMDC.getMethod("put", String.class, Object.class);
        this.get = jbossMDC.getMethod("get", String.class);
        this.getMap = jbossMDC.getMethod("getMap", new Class[0]);
        this.clear = jbossMDC.getMethod("clear", new Class[0]);
        this.remove = jbossMDC.getMethod("remove", String.class);
    }

    @Override
    public void put(String key, String val) {
        try {
            this.put.invoke(null, key, val);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not put key:[{0}] with val:[{1}] into jboss MDC:[{2}]", key, val, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public String get(String key) {
        try {
            Object getResult = this.get.invoke(null, key);
            return this.toString(getResult);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not get key:[{0}] from jboss MDC:[{1}]", key, e.getLocalizedMessage()), e);
            return null;
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.remove.invoke(null, key);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not remove key:[{0}] from jboss MDC:[{1}]", key, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public Map<String, String> getMap() {
        try {
            Map getMapResult = (Map)this.getMap.invoke(null, new Object[0]);
            return getMapResult.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toString(e.getValue())));
        }
        catch (Exception e2) {
            this.log.debug(MessageFormat.format("Could not getMap from jboss MDC:[{0}]", e2.getLocalizedMessage()), e2);
            return Collections.emptyMap();
        }
    }

    @Override
    public void clear() {
        try {
            this.clear.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not clear jboss MDC:[{0}]", e.getLocalizedMessage()), e);
        }
    }

    private String toString(Object getResult) {
        return getResult instanceof String || getResult == null ? (String)getResult : String.valueOf(getResult);
    }
}

