/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.se.logging.mdc;

import hu.icellmobilsoft.coffee.se.logging.DefaultLogger;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.se.logging.mdc.CoffeeMDCAdapter;
import hu.icellmobilsoft.coffee.se.logging.mdc.JbossMDCAdapter;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDCAdapter;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDCAdapterProvider;
import hu.icellmobilsoft.coffee.se.logging.mdc.Slf4jMDCAdapter;
import java.util.ServiceLoader;

public class MDCAdapters {
    private static final Logger LOGGER = DefaultLogger.getLogger(MDCAdapters.class);

    public static MDCAdapter findAdapter() {
        ServiceLoader<MDCAdapterProvider> mdcAdapterProviderLoader = ServiceLoader.load(MDCAdapterProvider.class);
        for (MDCAdapterProvider mdcAdapterProvider : mdcAdapterProviderLoader) {
            String providerName = mdcAdapterProvider.getClass().getName();
            try {
                LOGGER.trace("Loading MDCAdapter from MDCAdapterProvider:[{0}]", providerName);
                return mdcAdapterProvider.getAdapter();
            }
            catch (Exception e) {
                LOGGER.trace("Could not load MDCAdapter from MDCAdapterProvider:[{0}], [{1}]", e.getLocalizedMessage(), providerName);
            }
        }
        try {
            LOGGER.trace("Loading jboss MDC...");
            return new JbossMDCAdapter();
        }
        catch (Exception e) {
            LOGGER.trace("Could not load jboss MDC:[{0}]", e.getLocalizedMessage());
            try {
                LOGGER.trace("Loading slf4j MDC...");
                return new Slf4jMDCAdapter();
            }
            catch (Exception e2) {
                LOGGER.trace("Could not load slf4j MDC:[{0}]", e2.getLocalizedMessage());
                LOGGER.warn("Could not find any MDC implementation, falling back to CoffeeMDCAdapter!");
                return new CoffeeMDCAdapter();
            }
        }
    }
}

