/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.se.logging.mdc;

import hu.icellmobilsoft.coffee.se.logging.DefaultLogger;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.se.logging.mdc.MDCAdapter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;

public class Slf4jMDCAdapter
implements MDCAdapter {
    private Logger log = DefaultLogger.getLogger(Slf4jMDCAdapter.class);
    private Method put;
    private Method get;
    private Method getMap;
    private Method clear;
    private Method remove;

    public Slf4jMDCAdapter() throws Exception {
        Class<?> slf4jMDC = Class.forName("org.slf4j.MDC");
        this.put = slf4jMDC.getMethod("put", String.class, String.class);
        this.get = slf4jMDC.getMethod("get", String.class);
        this.getMap = slf4jMDC.getMethod("getCopyOfContextMap", new Class[0]);
        this.clear = slf4jMDC.getMethod("clear", new Class[0]);
        this.remove = slf4jMDC.getMethod("remove", String.class);
    }

    @Override
    public void put(String key, String val) {
        try {
            this.put.invoke(null, key, val);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not put key:[{0}] with val:[{1}] into slf4j MDC:[{2}]", key, val, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public String get(String key) {
        try {
            return (String)this.get.invoke(null, key);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not get key:[{0}] from slf4j MDC:[{1}]", key, e.getLocalizedMessage()), e);
            return null;
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.remove.invoke(null, key);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not remove key:[{0}] from slf4j MDC:[{1}]", key, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public Map<String, String> getMap() {
        try {
            return (Map)this.getMap.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not getMap from slf4j MDC:[{0}]", e.getLocalizedMessage()), e);
            return Collections.emptyMap();
        }
    }

    @Override
    public void clear() {
        try {
            this.clear.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.log.debug(MessageFormat.format("Could not clear slf4j MDC:[{0}]", e.getLocalizedMessage()), e);
        }
    }
}

