/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Date;

public class DateConverter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static Logger LOGGER = Logger.getLogger(DateConverter.class);

    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)date.getTime());
    }

    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            return new Date(jsonElement.getAsLong());
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not deserialize value:[{0}], returning null!", jsonElement.getAsLong());
            LOGGER.error(msg, (Throwable)e);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }
}

