/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.properties;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.inject.Vetoed;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class PropertyReader {
    private static Logger LOGGER = Logger.getLogger(PropertyReader.class);
    private static PropertyReader instance = null;
    private static final String DELIMITER = ".";
    private static final String CONFIG_FILE_KEY = "application.configurationFile";
    private LoadingCache<String, Properties> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Properties>(){

        public Properties load(String key) throws Exception {
            return PropertyReader.this.getSystemProperties(key);
        }
    });

    protected PropertyReader() {
    }

    public static PropertyReader getInstance() {
        if (instance == null) {
            instance = new PropertyReader();
        }
        return instance;
    }

    public String getSystemProperty(Class<?> c, String keyPart) {
        return this.getSystemProperty(c, keyPart, null);
    }

    public String getSystemProperty(Class<?> c, String keyPart, String defaultValue) {
        String key = c == null ? keyPart : c.getName() + DELIMITER + keyPart;
        LOGGER.debug("get system property: [{0}]", new Object[]{key});
        String value = null;
        try {
            Properties prop = (Properties)this.cache.get((Object)CONFIG_FILE_KEY);
            value = prop.getProperty(key);
            if (value == null && defaultValue != null) {
                LOGGER.warn("property not found, returning [{0}]", new Object[]{defaultValue});
                return defaultValue;
            }
            LOGGER.debug("system property value: [{0}]", new Object[]{value});
            return value;
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getLocalizedMessage());
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getSystemProperties(String key) {
        Properties prop = null;
        LOGGER.debug("system config property file is not in cache");
        InputStream fin = null;
        String configFileSystemProperty = System.getProperty(key);
        if (StringUtils.isBlank((CharSequence)configFileSystemProperty)) {
            LOGGER.error("Configuration file missing! Please set the [{0}] system property!!!!", new Object[]{CONFIG_FILE_KEY});
        } else {
            try {
                File propertyfile = new File(configFileSystemProperty);
                if (propertyfile.exists()) {
                    LOGGER.debug("Property file found, reading...");
                    fin = new FileInputStream(propertyfile);
                    prop = new Properties();
                    prop.load(fin);
                } else {
                    URL url = new URL(configFileSystemProperty);
                    URLConnection connection = url.openConnection();
                    fin = new BufferedInputStream(connection.getInputStream());
                    prop = new Properties();
                    prop.load(fin);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Can't read property file", (Throwable)e);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error in close inputsream", (Throwable)e);
                }
            }
        }
        return prop;
    }
}

