/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.annotation;

import hu.icellmobilsoft.coffee.cdi.annotation.Range;
import hu.icellmobilsoft.coffee.tool.version.ComparableVersion;
import jakarta.enterprise.inject.Vetoed;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class RangeUtil {
    public static boolean inRange(Range range, String value) {
        ComparableVersion to;
        ComparableVersion from;
        if (range == null || StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        ComparableVersion current = new ComparableVersion(value);
        boolean geFrom = StringUtils.isNotBlank((CharSequence)range.from()) ? current.compareTo(from = new ComparableVersion(range.from())) >= 0 : true;
        if (!geFrom) {
            return false;
        }
        boolean leTo = StringUtils.isNotBlank((CharSequence)range.to()) ? current.compareTo(to = new ComparableVersion(range.to())) <= 0 : true;
        return geFrom && leTo;
    }

    public static boolean inRanges(Range[] ranges, String value) {
        if (ranges == null || StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        for (Range range : ranges) {
            boolean inRange = RangeUtil.inRange(range, value);
            if (!inRange) continue;
            return true;
        }
        return false;
    }
}

