/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.clazz;

import jakarta.enterprise.inject.Vetoed;

@Vetoed
public class ResourceUtil {
    private static final String POSTFIX_JAR = ".jar";
    private static final String POSTFIX_WAR = ".war";
    private static final String PATH_SEPARATOR = "/";

    public static String getAppName(Class<?> clazz) {
        if (clazz == null || clazz.getProtectionDomain() == null || clazz.getProtectionDomain().getCodeSource() == null || clazz.getProtectionDomain().getCodeSource().getLocation() == null) {
            return null;
        }
        String result = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        result = ResourceUtil.truncatePostfix(result, POSTFIX_JAR);
        result = ResourceUtil.truncatePostfix(result, POSTFIX_WAR);
        result = ResourceUtil.truncatePrefix(result, PATH_SEPARATOR);
        return result;
    }

    private static String truncatePostfix(String result, String postfix) {
        if (result.indexOf(postfix) != -1) {
            result = result.substring(0, result.indexOf(postfix));
        }
        return result;
    }

    private static String truncatePrefix(String result, String prefix) {
        if (result.indexOf(prefix) != -1) {
            result = result.substring(result.lastIndexOf(prefix) + 1);
        }
        return result;
    }
}

