/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.compress;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.tool.gson.JsonUtil;
import jakarta.enterprise.inject.Vetoed;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

@Vetoed
public class GZIPUtil {
    public static byte[] compress(byte[] data) throws BaseException {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = null;
        try {
            gzipOutputStream = new GZIPOutputStream(outputStream);
            IOUtils.copy((InputStream)inputStream, (OutputStream)gzipOutputStream);
            gzipOutputStream.finish();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, "Error at compressing", (Throwable)ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)gzipOutputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] data) throws BaseException {
        byte[] byArray;
        if (data == null || data.length == 0) {
            return null;
        }
        if (!GZIPUtil.isCompressed(data)) {
            throw new TechnicalException((Enum)CoffeeFaultType.GZIP_DECOMPRESSION_ERROR, "Input data is not GZIP (does not have GZIP header)");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPInputStream gzipInputStream = null;
        try {
            gzipInputStream = new GZIPInputStream(inputStream);
            IOUtils.copy((InputStream)gzipInputStream, (OutputStream)outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new TechnicalException((Enum)CoffeeFaultType.GZIP_DECOMPRESSION_ERROR, "IOException at decompressing: " + e.getLocalizedMessage(), (Throwable)e);
                catch (Exception e2) {
                    throw new TechnicalException((Enum)CoffeeFaultType.GZIP_DECOMPRESSION_ERROR, "Exception at decompressing: " + e2.getLocalizedMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzipInputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)gzipInputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return byArray;
    }

    public static <T> T decompress(byte[] data, Class<T> clazz) throws BaseException {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] jsonByte = GZIPUtil.decompress(data);
        String jsonString = new String(jsonByte, StandardCharsets.UTF_8);
        return JsonUtil.toObject(jsonString, clazz);
    }

    public static int decompressedSize(byte[] data) {
        if (data == null || data.length < 4) {
            return 0;
        }
        if (!GZIPUtil.isCompressed(data)) {
            return data.length;
        }
        byte[] bytes = ArrayUtils.subarray((byte[])data, (int)(data.length - 4), (int)data.length);
        int fileSize = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (fileSize < 0) {
            fileSize = (int)((long)fileSize + 0x100000000L);
        }
        return fileSize;
    }

    public static boolean isCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

