/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.crypto;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import jakarta.enterprise.inject.Vetoed;
import java.security.Key;
import java.security.SecureRandom;
import java.text.MessageFormat;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@Vetoed
public class AesGcmUtil {
    public static final byte[] DEFAULT_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int IV_BYTE_LENGTH = 12;
    private static final int KEY_LENGTH = 256;
    private static final int KEY_BYTE_LENGTH = 32;
    private static final int AES_BLOCK_SIZE = 128;
    private static final String AES = "AES";
    private static final String CIPHER_AES_GCM_NOPADDING = "AES/GCM/NoPadding";

    public static byte[] generateKey() {
        byte[] key = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(key);
        return key;
    }

    public static byte[] generateIv() {
        byte[] key = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(key);
        return key;
    }

    public static byte[] encryptWithAes256GcmNoPadding(byte[] oneTimeKey, byte[] plainText) throws BaseException {
        return AesGcmUtil.encryptWithAes256GcmNoPadding(oneTimeKey, plainText, DEFAULT_IV);
    }

    public static byte[] encryptWithAes256GcmNoPadding(byte[] key, byte[] plainText, byte[] iv) throws BaseException {
        AesGcmUtil.checkKeyAndIVSize(key, iv);
        SecretKeySpec secretKey = new SecretKeySpec(key, AES);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, parameterSpec);
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static byte[] decryptWithAes256GcmNoPadding(byte[] oneTimeKey, byte[] encryptedBytes) throws BaseException {
        return AesGcmUtil.decryptWithAes256GcmNoPadding(oneTimeKey, encryptedBytes, DEFAULT_IV);
    }

    public static byte[] decryptWithAes256GcmNoPadding(byte[] key, byte[] encryptedBytes, byte[] iv) throws BaseException {
        AesGcmUtil.checkKeyAndIVSize(key, iv);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, parameterSpec);
            return cipher.doFinal(encryptedBytes);
        }
        catch (Exception e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void checkKeyAndIVSize(byte[] key, byte[] iv) throws BaseException {
        if (key == null || key.length != 32) {
            throw new InvalidParameterException(MessageFormat.format("Invalid key length or key is null! Expected key length in bytes: [{0}]", 32));
        }
        if (iv == null || iv.length != 12) {
            throw new InvalidParameterException(MessageFormat.format("Invalid IV length or IV is null! Expected IV length in bytes: [{0}]", 12));
        }
    }
}

