/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.date;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import jakarta.enterprise.inject.Vetoed;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class DateParseHelper {
    public static OffsetDateTime parseOffsetDateTimeEx(String from) throws BaseException {
        if (StringUtils.isBlank((CharSequence)from)) {
            return null;
        }
        try {
            return DateParseHelper.parseOffsetDateTime(from);
        }
        catch (Exception e) {
            throw new BaseException(MessageFormat.format("Couldn''t parse value:[{0}], msg:[{1}]! Value must be millis from UNIX epoch, or must comfort to one of 'YYYY-MM-DDThh:mm:ss.SSS', 'YYYY-MM-DDThh:mm:ss.SSSZ', 'YYYY-MM-DDThh:mm:ss.SSS+hh:mm'!", from, e.getLocalizedMessage()));
        }
    }

    private static OffsetDateTime parseOffsetDateTime(String from) {
        try {
            Long timeInMillis = Long.parseLong(from);
            Instant instant = Instant.ofEpochMilli(timeInMillis);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        catch (NumberFormatException e) {
            try {
                return OffsetDateTime.parse(from, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException ex) {
                LocalDateTime localDateTime = LocalDateTime.parse(from, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
            }
        }
    }

    public static OffsetTime parseOffsetTimeEx(String from) throws BaseException {
        if (StringUtils.isBlank((CharSequence)from)) {
            return null;
        }
        try {
            return DateParseHelper.parseOffsetTime(from);
        }
        catch (Exception e) {
            throw new BaseException(MessageFormat.format("Couldn''t parse value:[{0}], msg:[{1}]! Value must be string and comfort to one of 'hh:mm:ss.SSS', 'hh:mm:ss.SSSZ', 'hh:mm:ss.SSS+hh:mm'!", from, e.getLocalizedMessage()));
        }
    }

    private static OffsetTime parseOffsetTime(String from) {
        try {
            return OffsetTime.parse(from, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (DateTimeParseException ex) {
            LocalTime localTime = LocalTime.parse(from, DateTimeFormatter.ISO_LOCAL_TIME);
            return OffsetTime.of(localTime, ZoneOffset.UTC);
        }
    }

    public static LocalDate parseLocalDateEx(String from) throws BaseException {
        if (StringUtils.isBlank((CharSequence)from)) {
            return null;
        }
        try {
            return DateParseHelper.parseLocalDate(from);
        }
        catch (Exception e) {
            throw new BaseException(MessageFormat.format("Couldn''t parse value:[{0}], msg:[{1}]! Value must be millis from UNIX epoch, or must comfort to one of 'YYYY-MM-DD', 'YYYY-MM-DDZ', 'YYYY-MM-DD+hh:mm'!", from, e.getLocalizedMessage()));
        }
    }

    private static LocalDate parseLocalDate(String from) {
        try {
            Long timeInMillis = Long.parseLong(from);
            Instant instant = Instant.ofEpochMilli(timeInMillis);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate();
        }
        catch (NumberFormatException e) {
            return LocalDate.parse(from, DateTimeFormatter.ISO_DATE);
        }
    }
}

