/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.date;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.inject.Vetoed;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class DateUtil {
    private static Logger LOGGER = Logger.getLogger(DateUtil.class);
    public static final String DEFAULT_FULL_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date addValueToDate(Date date, int value, int measureUnit) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(measureUnit, value);
        return calendar.getTime();
    }

    public static Date parse(String dateString, String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern) || StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.error("Parsing stringDate [" + dateString + "] with pattern: [" + pattern + "] to Date failed: " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static long daysBetween(Date dateFrom, Date dateTo) {
        if (dateFrom == null || dateTo == null) {
            return 0L;
        }
        LocalDate fromDate = dateFrom.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate toDate = dateTo.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return Math.abs(ChronoUnit.DAYS.between(fromDate, toDate));
    }

    public static Date clearTimePart(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DateUtil.clearTimePart(cal).getTime();
    }

    public static Calendar clearTimePart(Calendar cal) {
        if (cal == null) {
            return null;
        }
        Calendar calendar = (Calendar)cal.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static int secondInDay(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        return hour * 60 * 60 + min * 60 + sec;
    }

    public static Date endTimeOfDate(Date day) {
        if (day == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static ZonedDateTime toZoneDateTime(String stringISODate) {
        if (StringUtils.isBlank((CharSequence)stringISODate)) {
            return null;
        }
        ZonedDateTime zonedDateTime = null;
        try {
            DateTimeFormatter f = DateTimeFormatter.ISO_INSTANT;
            zonedDateTime = ZonedDateTime.parse(stringISODate, f).withZoneSameInstant(ZoneId.systemDefault());
        }
        catch (DateTimeParseException e1) {
            try {
                DateTimeFormatter f = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
                zonedDateTime = ZonedDateTime.parse(stringISODate, f).withZoneSameInstant(ZoneId.systemDefault());
            }
            catch (DateTimeParseException e2) {
                LOGGER.error("Error in stringISODate parsing [" + stringISODate + "] with formats ISO_INSTANT and ISO_OFFSET_DATE_TIME:", (Throwable)e2);
            }
        }
        return zonedDateTime;
    }

    protected static GregorianCalendar toGregorianCalendar(Calendar c) {
        GregorianCalendar gc;
        if (c == null) {
            return null;
        }
        if (c instanceof GregorianCalendar) {
            gc = (GregorianCalendar)c.clone();
        } else {
            gc = new GregorianCalendar();
            gc.setTimeInMillis(c.getTimeInMillis());
        }
        return gc;
    }

    public static ZonedDateTime toZonedDateTime(Calendar cal) {
        if (cal == null) {
            return null;
        }
        if (cal instanceof GregorianCalendar) {
            return ((GregorianCalendar)cal).toZonedDateTime();
        }
        return ZonedDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static OffsetDateTime toOffsetDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZonedDateTime serverZonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return serverZonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.toZonedDateTime(date).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtil.toZonedDateTime(date).toLocalTime();
    }

    public static long monthsBetween(Date dateFrom, Date dateTo) {
        if (dateFrom == null || dateTo == null) {
            return 0L;
        }
        OffsetDateTime from = DateUtil.toOffsetDateTime(dateFrom);
        OffsetDateTime to = DateUtil.toOffsetDateTime(dateTo);
        return ChronoUnit.MONTHS.between(from, to);
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return Date.from(offsetDateTime.toInstant());
    }

    public static ZonedDateTime startZonedDateTime(YearMonth yearMonth) {
        if (yearMonth == null) {
            return null;
        }
        return yearMonth.atDay(1).atStartOfDay().atZone(ZoneId.systemDefault());
    }

    public static ZonedDateTime endZonedDateTime(YearMonth yearMonth) {
        if (yearMonth == null) {
            return null;
        }
        return yearMonth.atEndOfMonth().atTime(LocalTime.MAX).atZone(ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static OffsetDateTime nowUTC() {
        return OffsetDateTime.now(ZoneOffset.UTC);
    }

    public static OffsetDateTime nowUTCTruncatedToMillis() {
        return OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
    }

    public static LocalDate lastDayOfMonth(LocalDate baseDate) {
        if (baseDate == null) {
            return null;
        }
        return LocalDate.of(baseDate.getYear(), baseDate.getMonth(), baseDate.lengthOfMonth());
    }

    public static LocalDate lastDayOfQuarter(LocalDate baseDate) {
        if (baseDate == null) {
            return null;
        }
        int year = baseDate.getYear();
        Month firstMonthOfQuarter = baseDate.getMonth().firstMonthOfQuarter();
        Month lastMonthOfTheQuarter = firstMonthOfQuarter.plus(2L);
        return LocalDate.of(year, lastMonthOfTheQuarter, lastMonthOfTheQuarter.length(Year.isLeap(year)));
    }

    public static LocalDate lastDayOfYear(LocalDate baseDate) {
        if (baseDate == null) {
            return null;
        }
        int year = baseDate.getYear();
        return LocalDate.of(year, Month.DECEMBER, 31);
    }

    public static OffsetDateTime tryToParseToOffsetDateTime(String isoDateTime) throws BaseException {
        if (StringUtils.isBlank((CharSequence)isoDateTime)) {
            return null;
        }
        try {
            return OffsetDateTime.parse(isoDateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, MessageFormat.format("Invalid ISO date time format: [{0}]", isoDateTime));
        }
    }
}

