/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.marshalling;

import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.inject.Vetoed;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class MarshallingUtil {
    private static Logger LOGGER = Logger.getLogger(MarshallingUtil.class);
    private static final String WARN_CANNOT_CONVERT = "Cannot convert [{0}] object to xml: [{1}]";
    private static Map<String, JAXBContext> jaxbContextCache = new ConcurrentHashMap<String, JAXBContext>();

    public static String marshall(Object object) {
        try {
            return MarshallingUtil.marshallUncheckedXml(object);
        }
        catch (JAXBException e) {
            LOGGER.warn(WARN_CANNOT_CONVERT, new Object[]{object, e.getMessage()});
            LOGGER.trace("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static String marshallUncheckedXml(Object object) throws JAXBException {
        if (object == null) {
            LOGGER.warn("The object is null.");
            return null;
        }
        return MarshallingUtil.marshallUncheckedXml(object, object.getClass());
    }

    private static <T> JAXBContext getJaxbContext(Class<T> clazz) throws JAXBException {
        JAXBContext jaxbContext;
        String className = clazz.getName();
        if (jaxbContextCache.containsKey(className)) {
            jaxbContext = jaxbContextCache.get(className);
        } else {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            jaxbContextCache.put(className, jaxbContext);
        }
        return jaxbContext;
    }

    public static <T> String marshallUncheckedXml(Object object, Class<T> c) throws JAXBException {
        if (object == null || c == null) {
            LOGGER.warn("The object or type is null.");
            return null;
        }
        JAXBContext jc = MarshallingUtil.getJaxbContext(c);
        Marshaller m = jc.createMarshaller();
        return MarshallingUtil.marshallUncheckedXml(object, m);
    }

    public static String marshallUncheckedXml(Object object, Marshaller m) throws JAXBException {
        if (object == null) {
            LOGGER.warn("The object is null.");
            return null;
        }
        LOGGER.debug("Marshalling object to xml.");
        StringWriter writer = new StringWriter();
        m.marshal(object, (Writer)writer);
        return writer.toString();
    }

    public static void marshall(Object object, OutputStream s) {
        try {
            MarshallingUtil.marshallUncheckedXml(object, s);
        }
        catch (JAXBException e) {
            LOGGER.warn(WARN_CANNOT_CONVERT, new Object[]{object, e.getMessage()});
        }
    }

    public static <T> void marshall(Object object, OutputStream s, Class<T> c) {
        try {
            MarshallingUtil.marshallUncheckedXml(object, s, c);
        }
        catch (JAXBException e) {
            LOGGER.warn(WARN_CANNOT_CONVERT, new Object[]{object, e.getMessage()});
        }
    }

    public static void marshallUncheckedXml(Object object, OutputStream s) throws JAXBException {
        if (object == null || s == null) {
            LOGGER.warn("The object or stream is null.");
            return;
        }
        MarshallingUtil.marshallUncheckedXml(object, s, object.getClass());
    }

    public static <T> void marshallUncheckedXml(Object object, OutputStream s, Class<T> c) throws JAXBException {
        if (object == null || s == null || c == null) {
            LOGGER.warn("The object, type or stream is null.");
            return;
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{c});
        Marshaller m = jc.createMarshaller();
        m.marshal(object, s);
    }

    public static <T> T unmarshall(String str, Class<T> c) {
        try {
            return MarshallingUtil.unmarshallUncheckedXml(str, c);
        }
        catch (Exception e) {
            LOGGER.error("Error during unmarshalling JSON string: " + str, (Throwable)e);
            return null;
        }
    }

    public static <T> T unmarshallUncheckedXml(String str, Class<T> c) {
        if (StringUtils.isBlank((CharSequence)str) || c == null) {
            LOGGER.warn("The string source or the return type is null.");
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller um = jc.createUnmarshaller();
            StringReader reader = new StringReader(str);
            return (T)um.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            LOGGER.error("Error during unmarshalling XML string: " + str, (Throwable)e);
            return null;
        }
    }

    public static <T> void fillOptionalField(T lhs, JAXBElement<T> rhs, Consumer<T> setter) {
        if (rhs == null) {
            return;
        }
        if (rhs.isNil() && lhs != null) {
            setter.accept(null);
        } else if (!Objects.equals(lhs, rhs.getValue())) {
            setter.accept(rhs.getValue());
        }
    }
}

