/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import hu.icellmobilsoft.coffee.se.logging.Logger;
import jakarta.enterprise.inject.Vetoed;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Formatter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class EncodeUtil {
    private static Logger LOGGER = Logger.getLogger(EncodeUtil.class);

    public static String Sha512(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String sha = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-512");
            crypt.reset();
            crypt.update(str.getBytes(StandardCharsets.UTF_8));
            sha = EncodeUtil.byteToHex(crypt.digest());
        }
        catch (NullPointerException e) {
            LOGGER.error("Error in get SHA-512: encoded string is null!", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(MessageFormat.format("Error in get SHA-512 from [{0}]", str), (Throwable)e);
        }
        return StringUtils.upperCase(sha);
    }

    public static String byteToHex(byte[] hash) {
        if (Objects.isNull(hash)) {
            return null;
        }
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

