/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import jakarta.enterprise.inject.Vetoed;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class PasswordUtil {
    public static String encodeString(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        return DigestUtils.sha512Hex((String)string);
    }

    public static boolean isSame(String string, String encodedString) {
        return StringUtils.equals((CharSequence)PasswordUtil.encodeString(string), (CharSequence)encodedString);
    }

    public static boolean isStrong(String password) {
        if (StringUtils.isBlank((CharSequence)password) || password.length() < 8) {
            return false;
        }
        boolean numeric = false;
        boolean alphaLower = false;
        boolean alphaUpper = false;
        boolean special = false;
        for (char c : password.toCharArray()) {
            if (CharUtils.isAsciiNumeric((char)c)) {
                numeric = true;
            } else if (CharUtils.isAsciiAlphaLower((char)c)) {
                alphaLower = true;
            } else if (CharUtils.isAsciiAlphaUpper((char)c)) {
                alphaUpper = true;
            } else {
                special = true;
            }
            if (!numeric || !alphaLower || !alphaUpper || !special) continue;
            return true;
        }
        return false;
    }
}

