/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.string.RegexPatternCache;
import jakarta.enterprise.inject.Vetoed;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class StringUtil {
    private static Logger LOGGER = Logger.getLogger(StringUtil.class);
    private static RegexPatternCache patternCache = new RegexPatternCache();

    public static String upperCase(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String upper = string;
        if (string.contains("\u00df")) {
            upper = string.replaceAll("\u00df", "\u1e9e");
        }
        return StringUtils.upperCase((String)upper);
    }

    public static String encodeValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return value;
        }
    }

    public static String maskPropertyValue(String key, Object value, String ... keyPatterns) {
        String valueStr = StringUtil.toString(value);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, valueStr}) && keyPatterns != null) {
            for (String keyPattern : keyPatterns) {
                Pattern pattern;
                Matcher matcher;
                if (!StringUtils.isNotBlank((CharSequence)keyPattern) || !(matcher = (pattern = patternCache.getPattern(keyPattern)).matcher(key)).matches()) continue;
                return "*";
            }
        }
        return valueStr;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        Object unwrapped = value;
        if (value instanceof Optional && ((Optional)value).isPresent()) {
            unwrapped = ((Optional)value).get();
        }
        if (unwrapped.getClass().isArray()) {
            return ArrayUtils.toString((Object)unwrapped);
        }
        return unwrapped.toString();
    }

    public static String maskValueInXmlJson(String text, String ... keyPatterns) {
        String result = text;
        if (StringUtils.isNotBlank((CharSequence)text) && keyPatterns != null) {
            for (String keyPattern : keyPatterns) {
                result = StringUtil.replaceAllIgnoreCase(result, "<(" + keyPattern + ")>(.*?)<", "<$1>*<");
                result = StringUtil.replaceAllIgnoreCase(result, "(\"" + keyPattern + "\" *?: *?)\"(.*?)\"", "$1\"*\"");
            }
        }
        return result;
    }

    public static String replaceAllIgnoreCase(String text, String regex, String replacement) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{text, regex}) && replacement != null) {
            Pattern pattern = patternCache.getPattern(regex);
            Matcher matcher = pattern.matcher(text);
            return matcher.replaceAll(replacement);
        }
        return text;
    }

    public static String maskUriAuthenticationCredentials(String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return uri;
        }
        String regex = "//.*@";
        String replacement = "//*:*@";
        Pattern pattern = patternCache.getPattern(regex);
        Matcher matcher = pattern.matcher(uri);
        return matcher.replaceAll(replacement);
    }
}

