/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.version;

import hu.icellmobilsoft.coffee.tool.version.JavaVersion;
import jakarta.enterprise.inject.Vetoed;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;

@Vetoed
public class JavaVersionUtil {
    public static JavaVersion getCurrentSystemJavaVersion() {
        return JavaVersionUtil.getJavaVersion(System.getProperty("java.version"));
    }

    public static JavaVersion getJavaVersion(String versionProperty) {
        if (StringUtils.isBlank((CharSequence)versionProperty)) {
            throw new InvalidParameterException("versionProperty is required!");
        }
        JavaVersion javaVersion = new JavaVersion();
        try {
            String[] versionPart = versionProperty.split("\\.");
            if (versionPart.length > 0) {
                javaVersion.setMajor(Integer.parseInt(versionPart[0]));
            }
            if (versionPart.length > 1) {
                javaVersion.setFeature(Integer.parseInt(versionPart[1]));
            }
            if (versionPart.length > 2) {
                javaVersion.setPatch(versionPart[2]);
                String[] s = javaVersion.getPatch().split("_");
                if (s.length > 1) {
                    javaVersion.setPatchUpdate(Integer.parseInt(s[1]));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("Invalid java version! [" + versionProperty + "]");
        }
        return javaVersion;
    }
}

