/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.context;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;

public class ContextUtil {
    public static <T> T doLookup(String jndi, Class<T> clazz) throws BaseException {
        if (StringUtils.isBlank((CharSequence)jndi)) {
            return null;
        }
        if (clazz == null) {
            throw new InvalidParameterException("clazz cant be null!");
        }
        try {
            return InitialContext.doLookup(jndi);
        }
        catch (NamingException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.INVALID_REQUEST, "Exception in context lookup for [" + jndi + "]: [" + e.getLocalizedMessage() + "]", (Throwable)e);
        }
    }
}

