/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.gson.ByteArrayConverter;
import hu.icellmobilsoft.coffee.tool.gson.ClassTypeAdapter;
import hu.icellmobilsoft.coffee.tool.gson.DateConverter;
import hu.icellmobilsoft.coffee.tool.gson.DurationConverter;
import hu.icellmobilsoft.coffee.tool.gson.LocalDateConverter;
import hu.icellmobilsoft.coffee.tool.gson.OffsetDateTimeConverter;
import hu.icellmobilsoft.coffee.tool.gson.OffsetTimeConverter;
import hu.icellmobilsoft.coffee.tool.gson.XMLGregorianCalendarConverter;
import hu.icellmobilsoft.coffee.tool.gson.YearMonthConverter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.util.Date;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    private static final Logger LOGGER = Logger.getLogger(JsonUtil.class);
    private static final String ERROR_IN_PARSE_JSON_0_TRY_LENIENT = "Error in parse JSON [{0}], try lenient... ";
    private static final String CONVERTING_TO_OBJECT_SUCCESSFUL_0 = "Converting to Object successful: [{0}]";
    private static final String CONVERTING_TO_JSON_SUCCESSFUL_0 = "Converting to JSON successful: [{0}]";

    private JsonUtil() {
    }

    public static <T> T toObjectUncheckedEx(String json, Type typeOfT) throws BaseException {
        try {
            T dto = JsonUtil.toObjectUncheckedGson(json, typeOfT);
            LOGGER.debug(CONVERTING_TO_OBJECT_SUCCESSFUL_0, new Object[]{dto});
            return dto;
        }
        catch (Exception e) {
            throw new BaseException("Error in converting json [" + json + "] to [" + typeOfT + "]: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static <T> T toObjectUncheckedGson(String json, Type typeOfT) {
        Gson gson = JsonUtil.initGson();
        try {
            return (T)gson.fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(ERROR_IN_PARSE_JSON_0_TRY_LENIENT, new Object[]{e.getLocalizedMessage()});
            JsonReader reader = new JsonReader((Reader)new StringReader(json));
            reader.setLenient(true);
            return (T)gson.fromJson(reader, typeOfT);
        }
    }

    public static <T> T toObjectUncheckedGson(Reader reader, Type typeOfT) {
        Gson gson = JsonUtil.initGson();
        try {
            return (T)gson.fromJson(reader, typeOfT);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(ERROR_IN_PARSE_JSON_0_TRY_LENIENT, new Object[]{e.getLocalizedMessage()});
            JsonReader jsonreader = new JsonReader(reader);
            jsonreader.setLenient(true);
            return (T)gson.fromJson(jsonreader, typeOfT);
        }
    }

    public static String toJson(Object dto) {
        try {
            return JsonUtil.toJsonEx(dto);
        }
        catch (BaseException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toObject(String json, Class<T> classType) {
        try {
            return JsonUtil.toObjectEx(json, classType);
        }
        catch (BaseException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toObjectUnchecked(String json, Type typeOfT) {
        try {
            return JsonUtil.toObjectUncheckedEx(json, typeOfT);
        }
        catch (BaseException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static String toJsonEx(Object dto) throws BaseException {
        try {
            String json = JsonUtil.toJsonGson(dto);
            LOGGER.debug(CONVERTING_TO_JSON_SUCCESSFUL_0, new Object[]{StringUtils.abbreviate((String)json, (int)1000)});
            return json;
        }
        catch (Exception e) {
            throw new BaseException("Error in converting dto [" + dto.getClass() + "] to String: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static <T> T toObjectEx(String json, Class<T> classType) throws BaseException {
        try {
            T dto = JsonUtil.toObjectGson(json, classType);
            LOGGER.debug(CONVERTING_TO_OBJECT_SUCCESSFUL_0, new Object[]{dto});
            return dto;
        }
        catch (Exception e) {
            throw new BaseException("Error in converting json [" + json + "] to [" + classType + "]: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String toJsonGson(Object dto) {
        Gson gson = JsonUtil.initGson();
        return gson.toJson(dto);
    }

    public static <T> T toObjectGson(String json, Class<T> classType) {
        Gson gson = JsonUtil.initGson();
        try {
            return (T)gson.fromJson(json, classType);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(ERROR_IN_PARSE_JSON_0_TRY_LENIENT, new Object[]{e.getLocalizedMessage()});
            JsonReader reader = new JsonReader((Reader)new StringReader(json));
            reader.setLenient(true);
            return (T)gson.fromJson(reader, classType);
        }
    }

    public static <T> T toObjectGson(Reader reader, Class<T> classType) {
        Gson gson = JsonUtil.initGson();
        try {
            return (T)gson.fromJson(reader, classType);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn(ERROR_IN_PARSE_JSON_0_TRY_LENIENT, new Object[]{e.getLocalizedMessage()});
            JsonReader jsonreader = new JsonReader(reader);
            jsonreader.setLenient(true);
            return (T)gson.fromJson(jsonreader, classType);
        }
    }

    private static Gson initGson() {
        return new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Class.class, (Object)new ClassTypeAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarConverter()).registerTypeAdapter(Date.class, (Object)new DateConverter()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeConverter()).registerTypeAdapter(OffsetTime.class, (Object)new OffsetTimeConverter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateConverter()).registerTypeAdapter(Duration.class, (Object)new DurationConverter()).registerTypeAdapter(YearMonth.class, (Object)new YearMonthConverter()).registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayConverter()).create();
    }
}

