/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.date.DateParseHelper;
import hu.icellmobilsoft.coffee.tool.utils.date.DatePrintUtil;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.time.LocalDate;

public class LocalDateConverter
implements JsonSerializer<LocalDate>,
JsonDeserializer<LocalDate> {
    private static Logger LOGGER = Logger.getLogger(LocalDateConverter.class);

    public LocalDate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String offsetDateTimAsString = json.getAsString();
        try {
            return DateParseHelper.parseLocalDateEx(offsetDateTimAsString);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not deserialize value:[{0}]!", offsetDateTimAsString);
            LOGGER.error(msg, (Throwable)e);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }

    public JsonElement serialize(LocalDate src, Type typeOfSrc, JsonSerializationContext context) {
        try {
            String marshalled = DatePrintUtil.isoDate(src);
            return new JsonPrimitive(marshalled);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not serialize src:[{0}]!", src);
            LOGGER.error(msg, (Throwable)e);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }
}

