/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.date.DateXmlUtil;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter
implements JsonSerializer<XMLGregorianCalendar>,
JsonDeserializer<XMLGregorianCalendar> {
    private static Logger LOGGER = Logger.getLogger(XMLGregorianCalendarConverter.class);

    public JsonElement serialize(XMLGregorianCalendar calendar, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(calendar.toXMLFormat());
    }

    public XMLGregorianCalendar deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            XMLGregorianCalendar xmlCal = this.toXMLGregorianCalendar(jsonElement.getAsString());
            return xmlCal.normalize();
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not deserialize value:[{0}]!", jsonElement.getAsString());
            LOGGER.error(msg, (Throwable)e);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(String string) throws DatatypeConfigurationException {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(Long.parseLong(string));
            return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar(calendar);
        }
        catch (NumberFormatException e) {
            return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar(string);
        }
    }
}

