/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.time.YearMonth;

public class YearMonthConverter
implements JsonSerializer<YearMonth>,
JsonDeserializer<YearMonth> {
    public YearMonth deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            this.handleNotJsonPrimitive(json);
        }
        String offsetDateTimeAsString = json.getAsString();
        try {
            return YearMonth.parse(offsetDateTimeAsString);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not deserialize value:[{0}]!", offsetDateTimeAsString);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }

    public JsonElement serialize(YearMonth src, Type type, JsonSerializationContext jsonSerializationContext) {
        try {
            return new JsonPrimitive(src.toString());
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Could not serialize src:[{0}]!", src);
            throw new JsonParseException(msg, (Throwable)e);
        }
    }

    private void handleNotJsonPrimitive(JsonElement json) {
        String jsonString = json.toString();
        String msg = json.isJsonObject() ? MessageFormat.format("Invalid element! Element is object: [{0}]! Provide value only, such as: 2011-12!", jsonString) : (json.isJsonArray() ? MessageFormat.format("Invalid element! Element is an array: [{0}]! Provide valid value, such as: 2011-12!", jsonString) : (json.isJsonNull() ? "Invalid element! Element is null! Provide valid value, such as: 2011-12!" : MessageFormat.format("Invalid element! [{0}]! Provide valid value, such as: 2011-12!", jsonString)));
        throw new JsonParseException(msg);
    }
}

