/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.annotation;

import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class AnnotationUtil {
    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        if (clazz == null) {
            return null;
        }
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null && clazz.isSynthetic()) {
            return AnnotationUtil.getAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return annotation;
    }

    public static <A extends Annotation> Optional<A> getAnnotation(InjectionPoint injectionPoint, Class<A> annotationClazz) {
        if (injectionPoint == null || annotationClazz == null) {
            return Optional.empty();
        }
        if (injectionPoint.getAnnotated() != null && injectionPoint.getAnnotated().isAnnotationPresent(annotationClazz)) {
            return Optional.ofNullable(injectionPoint.getAnnotated().getAnnotation(annotationClazz));
        }
        if (injectionPoint.getQualifiers() != null) {
            for (Annotation qualifier : injectionPoint.getQualifiers()) {
                if (qualifier == null || !annotationClazz.isAssignableFrom(qualifier.getClass())) continue;
                return Optional.of(qualifier);
            }
        }
        return Optional.empty();
    }
}

