/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.crypto;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.tool.utils.crypto.SecretKeyUtil;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AesCbcCryptoUtil {
    public static final byte[] DEFAULT_VECTOR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5PADDING";
    private static final String WRONG_OR_MISSING_PARAMETERS_MSG = "One of the required param is missing.";
    private static final String INIT_VECTOR_BLANK_MSG = "Input initVector is blank!";

    private AesCbcCryptoUtil() {
    }

    public static byte[] encrypt(byte[] dataToEncrypt, char[] key) throws BaseException {
        return AesCbcCryptoUtil.encrypt(dataToEncrypt, key, AesCbcCryptoUtil.defaultIvParameterSpec());
    }

    public static InputStream encrypt(InputStream dataToEncrypt, char[] key) throws BaseException {
        return AesCbcCryptoUtil.encrypt(dataToEncrypt, key, AesCbcCryptoUtil.defaultIvParameterSpec());
    }

    public static byte[] encrypt(byte[] dataToEncrypt, char[] key, String initVector) throws BaseException {
        if (StringUtils.isBlank((CharSequence)initVector)) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, INIT_VECTOR_BLANK_MSG);
        }
        IvParameterSpec ivspec = new IvParameterSpec(initVector.getBytes(StandardCharsets.UTF_8));
        return AesCbcCryptoUtil.encrypt(dataToEncrypt, key, (AlgorithmParameterSpec)ivspec);
    }

    public static InputStream encrypt(InputStream dataToEncrypt, char[] key, String initVector) throws BaseException {
        if (StringUtils.isBlank((CharSequence)initVector)) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, INIT_VECTOR_BLANK_MSG);
        }
        IvParameterSpec ivspec = new IvParameterSpec(initVector.getBytes(StandardCharsets.UTF_8));
        return AesCbcCryptoUtil.encrypt(dataToEncrypt, key, (AlgorithmParameterSpec)ivspec);
    }

    private static byte[] encrypt(byte[] dataToEncrypt, char[] key, AlgorithmParameterSpec ivSpec) throws BaseException {
        if (dataToEncrypt == null || key == null || ivSpec == null) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, WRONG_OR_MISSING_PARAMETERS_MSG);
        }
        try {
            SecretKeySpec keySpec = SecretKeyUtil.defaultAES256SecretKeySpec(key);
            Cipher c = Cipher.getInstance(CIPHER_TRANSFORMATION);
            c.init(1, (Key)keySpec, ivSpec);
            return c.doFinal(dataToEncrypt);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Encryption failed: [{0}]", e.getLocalizedMessage());
            throw new BaseException((Enum)CoffeeFaultType.FAILED_TO_CIPHER_DOCUMENT, msg, (Throwable)e);
        }
    }

    private static InputStream encrypt(InputStream streamToEncrypt, char[] key, AlgorithmParameterSpec ivSpec) throws BaseException {
        if (streamToEncrypt == null || key == null || ivSpec == null) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, WRONG_OR_MISSING_PARAMETERS_MSG);
        }
        try {
            SecretKeySpec keySpec = SecretKeyUtil.defaultAES256SecretKeySpec(key);
            Cipher c = Cipher.getInstance(CIPHER_TRANSFORMATION);
            c.init(1, (Key)keySpec, ivSpec);
            return new CipherInputStream(streamToEncrypt, c);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Encryption failed: [{0}]", e.getLocalizedMessage());
            throw new BaseException((Enum)CoffeeFaultType.FAILED_TO_CIPHER_DOCUMENT, msg, (Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] encryptedData, char[] key) throws BaseException {
        return AesCbcCryptoUtil.decrypt(encryptedData, key, AesCbcCryptoUtil.defaultIvParameterSpec());
    }

    public static InputStream decrypt(InputStream encryptedData, char[] key) throws BaseException {
        return AesCbcCryptoUtil.decrypt(encryptedData, key, AesCbcCryptoUtil.defaultIvParameterSpec());
    }

    public static byte[] decrypt(byte[] encryptedData, char[] key, String initVector) throws BaseException {
        if (StringUtils.isBlank((CharSequence)initVector)) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, INIT_VECTOR_BLANK_MSG);
        }
        IvParameterSpec ivspec = new IvParameterSpec(initVector.getBytes(StandardCharsets.UTF_8));
        return AesCbcCryptoUtil.decrypt(encryptedData, key, (AlgorithmParameterSpec)ivspec);
    }

    public static InputStream decrypt(InputStream encryptedData, char[] key, String initVector) throws BaseException {
        if (StringUtils.isBlank((CharSequence)initVector)) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, INIT_VECTOR_BLANK_MSG);
        }
        IvParameterSpec ivspec = new IvParameterSpec(initVector.getBytes(StandardCharsets.UTF_8));
        return AesCbcCryptoUtil.decrypt(encryptedData, key, (AlgorithmParameterSpec)ivspec);
    }

    private static byte[] decrypt(byte[] encodedData, char[] key, AlgorithmParameterSpec ivSpec) throws BaseException {
        if (encodedData == null || key == null || ivSpec == null) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, WRONG_OR_MISSING_PARAMETERS_MSG);
        }
        try {
            SecretKeySpec keySpec = SecretKeyUtil.defaultAES256SecretKeySpec(key);
            Cipher c = Cipher.getInstance(CIPHER_TRANSFORMATION);
            c.init(2, (Key)keySpec, ivSpec);
            return c.doFinal(encodedData);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Decryption failed: [{0}]", e.getLocalizedMessage());
            throw new BaseException((Enum)CoffeeFaultType.FAILED_TO_DECIPHER_DOCUMENT, msg, (Throwable)e);
        }
    }

    private static InputStream decrypt(InputStream encodedData, char[] key, AlgorithmParameterSpec ivSpec) throws BaseException {
        if (encodedData == null || key == null || ivSpec == null) {
            throw new BaseException((Enum)CoffeeFaultType.WRONG_OR_MISSING_PARAMETERS, WRONG_OR_MISSING_PARAMETERS_MSG);
        }
        try {
            SecretKeySpec keySpec = SecretKeyUtil.defaultAES256SecretKeySpec(key);
            Cipher c = Cipher.getInstance(CIPHER_TRANSFORMATION);
            c.init(2, (Key)keySpec, ivSpec);
            return new CipherInputStream(encodedData, c);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Decryption failed: [{0}]", e.getLocalizedMessage());
            throw new BaseException((Enum)CoffeeFaultType.FAILED_TO_DECIPHER_DOCUMENT, msg, (Throwable)e);
        }
    }

    private static AlgorithmParameterSpec defaultIvParameterSpec() {
        return new IvParameterSpec(DEFAULT_VECTOR);
    }

    public static String to16LengthInitVector(String sourceString) {
        return StringUtils.rightPad((String)StringUtils.substring((String)sourceString, (int)0, (int)16), (int)16, (char)'0');
    }
}

