/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.crypto;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import java.text.MessageFormat;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class SecretKeyUtil {
    public static final byte[] SALT = new byte[]{0};
    public static final int ITERATION = 1000;
    public static final int KEY_LENGTH = 256;
    public static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final String ALGORITHM_AES = "AES";

    private SecretKeyUtil() {
    }

    public static SecretKeySpec defaultAES256SecretKeySpec(char[] password) throws BaseException {
        if (password == null || password.length == 0) {
            throw new InvalidParameterException("Input password is null");
        }
        return SecretKeyUtil.AES256SecretKeySpec(password, SALT, 1000, 256, SECRET_KEY_ALGORITHM, ALGORITHM_AES);
    }

    public static SecretKeySpec AES256SecretKeySpec(char[] password, byte[] salt, int iteration, int keyLength, String secretKeyFactoryAlgorithm, String secretKeySpecAlgorithm) throws BaseException {
        if (password == null) {
            throw new InvalidParameterException("Input password is null");
        }
        if (salt == null) {
            throw new InvalidParameterException("Input salt is null");
        }
        if (StringUtils.isBlank((CharSequence)secretKeyFactoryAlgorithm)) {
            throw new InvalidParameterException("Input secretKeyFactoryAlgorithm is empty");
        }
        if (StringUtils.isBlank((CharSequence)secretKeySpecAlgorithm)) {
            throw new InvalidParameterException("Input secretKeySpecAlgorithm is empty");
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iteration, keyLength);
            SecretKeyFactory f = SecretKeyFactory.getInstance(secretKeyFactoryAlgorithm);
            byte[] keyByte = f.generateSecret(spec).getEncoded();
            return new SecretKeySpec(keyByte, secretKeySpecAlgorithm);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error by generating SecretKey: [{0}]", e.getLocalizedMessage());
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, msg, (Throwable)e);
        }
    }
}

