/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.date;

import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DatePrintUtil {
    public static String isoDate(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return DateTimeFormatter.ISO_DATE.format(temporal);
    }

    public static String isoOffsetTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_TIME.format(temporal);
    }

    public static String isoOffsetDateTime(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(temporal);
    }

    public static String printDate(TemporalAccessor temporalAccessor, String pattern) {
        if (temporalAccessor == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return temporalAccessor.toString();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.format(temporalAccessor);
    }

    public static String printDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return date.toString();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String printCalendar(Calendar cal, String pattern) {
        if (cal == null) {
            return null;
        }
        return DatePrintUtil.printDate(cal.getTime(), pattern);
    }
}

