/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.date;

import hu.icellmobilsoft.coffee.tool.utils.date.DateUtil;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class DateXmlUtil {
    private static DatatypeFactory datatypeFactory;

    public static XMLGregorianCalendar toXMLGregorianCalendar(Calendar c) {
        if (c == null) {
            return null;
        }
        if (c instanceof GregorianCalendar) {
            return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar((GregorianCalendar)c);
        }
        GregorianCalendar gc = new GregorianCalendar(c.getTimeZone());
        gc.setTimeInMillis(c.getTimeInMillis());
        return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar(gc);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        return DateXmlUtil.toXMLGregorianCalendar(DateUtil.toCalendar(date));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(GregorianCalendar calendar, int offsetInMinutes) {
        if (calendar == null) {
            return null;
        }
        XMLGregorianCalendar xmlCalendar = DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendarDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), offsetInMinutes);
        xmlCalendar.setHour(calendar.get(11));
        xmlCalendar.setMinute(calendar.get(12));
        xmlCalendar.setSecond(calendar.get(13));
        xmlCalendar.setMillisecond(calendar.get(14));
        return xmlCalendar;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarNoTimeZone(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return DateXmlUtil.toXMLGregorianCalendar(calendar, Integer.MIN_VALUE);
    }

    public static Calendar toCalendar(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return xmlGregorianCalendar.toGregorianCalendar();
    }

    public static Date toDate(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return xmlGregorianCalendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarFromISO(String stringISODate) {
        if (StringUtils.isBlank((CharSequence)stringISODate)) {
            return null;
        }
        ZonedDateTime zonedDateTime = DateUtil.toZoneDateTime(stringISODate);
        if (zonedDateTime == null) {
            return null;
        }
        GregorianCalendar gcal = GregorianCalendar.from(zonedDateTime);
        return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar(gcal);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return DateXmlUtil.toXMLGregorianCalendar(GregorianCalendar.from(offsetDateTime.toZonedDateTime()));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendar(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0);
    }

    public static Date toDateAsLocal(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        GregorianCalendar cal = xmlGregorianCalendar.toGregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        return cal.getTime();
    }

    public static Date toDateOnly(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        LocalDate localDate = DateXmlUtil.toZonedDateTime(xmlGregorianCalendar).toLocalDate();
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarAsUTC(Calendar c) {
        if (c == null) {
            return null;
        }
        GregorianCalendar gc = DateUtil.toGregorianCalendar(c);
        XMLGregorianCalendar xmlCalendar = DateXmlUtil.toXMLGregorianCalendar(gc, 0);
        if (xmlCalendar == null) {
            return null;
        }
        xmlCalendar.setMillisecond(gc.get(14));
        return xmlCalendar;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarAsUTC(Date date) {
        if (date == null) {
            return null;
        }
        return DateXmlUtil.toXMLGregorianCalendarAsUTC(DateUtil.toCalendar(date));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarDateOnly(Calendar c) {
        if (c == null) {
            return null;
        }
        return DateXmlUtil.getDatatypeFactory().newXMLGregorianCalendarDate(c.get(1), c.get(2) + 1, c.get(5), 0);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarDateOnly(Date date) {
        if (date == null) {
            return null;
        }
        return DateXmlUtil.toXMLGregorianCalendarDateOnly(DateUtil.toCalendar(date));
    }

    public static ZonedDateTime toZonedDateTime(XMLGregorianCalendar xmlCal) {
        if (xmlCal == null) {
            return null;
        }
        return xmlCal.toGregorianCalendar().toZonedDateTime();
    }

    public static LocalDate toLocalDate(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return LocalDate.of(xmlGregorianCalendar.getYear(), xmlGregorianCalendar.getMonth(), xmlGregorianCalendar.getDay());
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarInUTC(Calendar cal) {
        if (cal == null) {
            return null;
        }
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        return DateXmlUtil.toXMLGregorianCalendar(calendar);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendarInUTC(Date date) {
        return DateXmlUtil.toXMLGregorianCalendarInUTC(DateUtil.toCalendar(date));
    }

    public static XMLGregorianCalendar clearTime(XMLGregorianCalendar xmlCal) {
        if (xmlCal == null) {
            return null;
        }
        XMLGregorianCalendar dateOnly = (XMLGregorianCalendar)xmlCal.clone();
        dateOnly.setFractionalSecond(null);
        dateOnly.setHour(Integer.MIN_VALUE);
        dateOnly.setMillisecond(Integer.MIN_VALUE);
        dateOnly.setMinute(Integer.MIN_VALUE);
        dateOnly.setSecond(Integer.MIN_VALUE);
        dateOnly.setTimezone(Integer.MIN_VALUE);
        return dateOnly;
    }

    public static XMLGregorianCalendar cloneXMLGregorianCalendar(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar == null) {
            return null;
        }
        return (XMLGregorianCalendar)xmlGregorianCalendar.clone();
    }

    public static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Cannot create DatatypeFactory instance", e);
            }
        }
        return datatypeFactory;
    }
}

