/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.stream;

import hu.icellmobilsoft.coffee.tool.utils.stream.LoggingEvent;
import hu.icellmobilsoft.coffee.tool.utils.stream.LoggingPublisher;
import hu.icellmobilsoft.coffee.tool.utils.string.StringHelper;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;

public class RequestLoggerInputStream
extends InputStream {
    private final InputStream inputStream;
    private final String requestPrefix;
    private final StringBuilder entityLog = new StringBuilder();
    private final StringBuilder logMessage;
    private int logCollectLimit;
    private boolean isLogged = false;

    public RequestLoggerInputStream(InputStream requestEntityStream, int logCollectLimit, String requestPrefix, StringBuilder logMessage) {
        this.inputStream = requestEntityStream;
        this.logCollectLimit = logCollectLimit;
        this.requestPrefix = requestPrefix;
        this.logMessage = logMessage;
    }

    @Override
    public int read() throws IOException {
        int streamData = -1;
        try {
            streamData = this.inputStream.read();
        }
        catch (IOException e) {
            this.prepareAndSendLoggingEvent();
            this.isLogged = true;
            throw e;
        }
        if (streamData != -1 && this.logCollectLimit != 0) {
            this.entityLog.append((char)streamData);
            --this.logCollectLimit;
        } else if (!this.isLogged) {
            this.prepareAndSendLoggingEvent();
            this.isLogged = true;
        }
        return streamData;
    }

    private void prepareAndSendLoggingEvent() {
        String maskedEntityLog = this.getMaskedEntity(this.entityLog.toString());
        this.logMessage.append(maskedEntityLog);
        LoggingEvent event = new LoggingEvent(this.logMessage.toString());
        LoggingPublisher loggingPublisher = (LoggingPublisher)CDI.current().select(LoggingPublisher.class, new Annotation[0]).get();
        loggingPublisher.publish(event);
    }

    private String getMaskedEntity(String entityLogText) {
        String maskedText = StringHelper.maskValueInXmlJson(entityLogText);
        return this.requestPrefix + "entity: [" + maskedText + "]\n";
    }
}

