/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ResponseEntityCollectorOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BYTE_ARRAY_SIZE = 1024;
    private final OutputStream originalResponseStream;
    private final ByteArrayOutputStream entityLog;
    private int logCollectLimit;

    public ResponseEntityCollectorOutputStream(OutputStream originalResponseStream, int logCollectLimit) {
        this.originalResponseStream = originalResponseStream;
        this.logCollectLimit = logCollectLimit;
        this.entityLog = new ByteArrayOutputStream(logCollectLimit > 0 ? logCollectLimit : 1024);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.logCollectLimit != 0) {
            this.entityLog.write(b);
            --this.logCollectLimit;
        }
        this.originalResponseStream.write(b);
    }

    public byte[] getEntity() {
        return this.entityLog.toByteArray();
    }
}

