/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Formatter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EncodeUtil {
    private static Logger LOGGER = Logger.getLogger(EncodeUtil.class);
    public static final String ALGORITHM_SHA_512 = "SHA-512";
    public static final String ALGORITHM_SHA3_512 = "SHA3-512";

    @Deprecated(forRemoval=true, since="2.5.0")
    public static String Sha512(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String sha = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance(ALGORITHM_SHA_512);
            crypt.reset();
            crypt.update(str.getBytes(StandardCharsets.UTF_8));
            sha = EncodeUtil.byteToHex(crypt.digest());
        }
        catch (NullPointerException e) {
            LOGGER.error("Error in get SHA-512: encoded string is null!", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(MessageFormat.format("Error in get SHA-512 from [{0}]", str), (Throwable)e);
        }
        return StringUtils.upperCase(sha);
    }

    public static String sha_512(String stringInput) throws BaseException {
        if (StringUtils.isBlank((CharSequence)stringInput)) {
            return null;
        }
        String sha = EncodeUtil.messageDigest(stringInput.getBytes(StandardCharsets.UTF_8), ALGORITHM_SHA_512);
        return StringUtils.upperCase((String)sha);
    }

    public static String sha3_512(String stringInput) throws BaseException {
        if (StringUtils.isBlank((CharSequence)stringInput)) {
            return null;
        }
        String sha = EncodeUtil.messageDigest(stringInput.getBytes(StandardCharsets.UTF_8), ALGORITHM_SHA3_512);
        return StringUtils.upperCase((String)sha);
    }

    public static String messageDigest(byte[] input, String algorithm) throws BaseException {
        if (Objects.isNull(input)) {
            throw new InvalidParameterException("input is null!");
        }
        if (StringUtils.isBlank((CharSequence)algorithm)) {
            throw new InvalidParameterException("algorithm is null!");
        }
        try {
            MessageDigest crypt = MessageDigest.getInstance(algorithm);
            crypt.reset();
            crypt.update(input);
            return EncodeUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format("Error in get [{0}] from input", algorithm), (Throwable)e);
        }
    }

    public static String byteToHex(byte[] hash) {
        if (Objects.isNull(hash)) {
            return null;
        }
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

