/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.regex.Pattern;

public class RegexPatternCache {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private CacheLoader<String, Pattern> loader = new CacheLoader<String, Pattern>(){

        public Pattern load(String key) {
            return Pattern.compile(key, 2);
        }
    };
    private final LoadingCache<String, Pattern> cache;

    public RegexPatternCache() {
        this(10000);
    }

    public RegexPatternCache(int cacheSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(this.loader);
    }

    public Pattern getPattern(String patternKey) {
        return (Pattern)this.cache.getUnchecked((Object)patternKey);
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

