/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.string;

import hu.icellmobilsoft.coffee.tool.utils.string.StringUtil;
import jakarta.enterprise.context.Dependent;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Dependent
public class StringHelper {
    public static final String[] DEFAULT_PATTERN = new String[]{"[\\w\\s]*?secret[\\w\\s]*?", "[\\w\\s]*?pass[\\w\\s]*?"};
    private static Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().build();

    public static String maskPropertyValue(String key, Object value) {
        return StringUtil.maskPropertyValue(key, value, StringHelper.getSensitiveKeyPattern());
    }

    public static String maskValueInXmlJson(String text) {
        return StringUtil.maskValueInXmlJson(text, StringHelper.getSensitiveKeyPattern());
    }

    public static String[] getSensitiveKeyPattern() {
        Optional patternOpt = config.getOptionalValue("coffee.config.log.sensitive.key.pattern", String[].class);
        return patternOpt.filter(patternArray -> ((String[])patternArray).length > 0).orElse(DEFAULT_PATTERN);
    }
}

