/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.tool.utils.validation;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ParamValidatorUtil {
    private ParamValidatorUtil() {
    }

    public static <T> T requireNonNull(T object, String paramName) throws BaseException {
        if (Objects.isNull(object)) {
            throw ParamValidatorUtil.newInvalidParameterException("[{0}] object is null!", paramName);
        }
        return object;
    }

    public static String requireNonBlank(String object, String paramName) throws BaseException {
        if (StringUtils.isBlank((CharSequence)object)) {
            throw ParamValidatorUtil.newInvalidParameterException("[{0}] object is blank!", paramName);
        }
        return object;
    }

    public static <T> T requireNonEmpty(Optional<T> object, String paramName) throws BaseException {
        ParamValidatorUtil.requireNonNull(object, paramName);
        return object.orElseThrow(() -> ParamValidatorUtil.newInvalidParameterException("[{0}] object is empty!", paramName));
    }

    public static <T> Collection<T> requireNonEmpty(Collection<T> object, String paramName) throws BaseException {
        ParamValidatorUtil.requireNonNull(object, paramName);
        if (object.isEmpty()) {
            throw ParamValidatorUtil.newInvalidParameterException("[{0}] object is empty!", paramName);
        }
        return object;
    }

    private static BaseException newInvalidParameterException(String messagePattern, Object ... messageArguments) {
        return new InvalidParameterException(MessageFormat.format(messagePattern, messageArguments));
    }
}

