/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.common.util;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.roaster.api.TestException;
import hu.icellmobilsoft.roaster.common.util.ExceptionConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());
    public static final String SRC_TEST_RESOURCES = "src/test/resources/";

    public static String readFile(String first, String ... more) {
        Path path = Path.of(first, more);
        return FileUtil.readFile(path);
    }

    public static String readFileFromResource(String fileName) {
        String string;
        block9: {
            if (StringUtils.isBlank((CharSequence)fileName)) {
                return null;
            }
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);
            try {
                String file = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                LOG.info(() -> MessageFormat.format("File [{0}] from resources read!", ClassLoader.getSystemResource(fileName)));
                string = file;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TestException(MessageFormat.format("Unable to read File [{0}] from resource", fileName), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static void readFileFromResource(String fileName, ExceptionConsumer<InputStream, Exception> function) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return;
        }
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);){
            function.accept(inputStream);
            LOG.info(() -> MessageFormat.format("File [{0}] from resources read!", ClassLoader.getSystemResource(fileName)));
        }
        catch (IOException e) {
            throw new TestException(MessageFormat.format("Unable to read File [{0}] from resource", fileName), (Throwable)e);
        }
        catch (BaseException e) {
            throw new TestException(MessageFormat.format("BaseException during reading File [{0}] from resource", fileName), (Throwable)e);
        }
        catch (Exception e) {
            throw new TestException(MessageFormat.format("Exception during reading File [{0}] from resource", fileName), (Throwable)e);
        }
    }

    public static void readFile(Path path, ExceptionConsumer<InputStream, Exception> function) {
        if (path == null) {
            throw new TestException("path is null!");
        }
        try {
            function.accept(Files.newInputStream(path, new OpenOption[0]));
            LOG.info(() -> MessageFormat.format("File from path [{0}] read!", path.toAbsolutePath()));
        }
        catch (IOException e) {
            throw new TestException(MessageFormat.format("Unable to read File from path: [{0}]", path.toAbsolutePath()), (Throwable)e);
        }
        catch (BaseException e) {
            throw new TestException(MessageFormat.format("BaseException during reading File from path: [{0}]", path.toAbsolutePath()), (Throwable)e);
        }
        catch (Exception e) {
            throw new TestException(MessageFormat.format("Exception during reading File from path: [{0}]", path.toAbsolutePath()), (Throwable)e);
        }
    }

    public static String readFile(Path path) {
        if (path == null) {
            throw new TestException("path is null!");
        }
        try {
            String file = Files.readString(path);
            LOG.info(() -> MessageFormat.format("File from path [{0}] read!", path.toAbsolutePath()));
            return file;
        }
        catch (IOException e) {
            throw new TestException(MessageFormat.format("Unable to read File from path: [{0}]", path.toAbsolutePath()), (Throwable)e);
        }
    }
}

