/*
 * Decompiled with CFR 0.152.
 */
package hu.supercluster.overpasser.library.query;

import hu.supercluster.overpasser.library.query.AbstractOverpassSubQuery;
import hu.supercluster.overpasser.library.query.OverpassQuery;
import hu.supercluster.overpasser.library.query.OverpassQueryBuilder;
import java.util.Set;

public class OverpassFilterQuery
extends AbstractOverpassSubQuery {
    private boolean separateNext;

    public OverpassFilterQuery(OverpassQuery parent) {
        super(parent);
        this.init();
    }

    OverpassFilterQuery(OverpassQuery parent, OverpassQueryBuilder builder) {
        super(parent, builder);
        this.init();
    }

    void init() {
        this.builder.append("; (");
    }

    public OverpassFilterQuery prepareNext() {
        this.separateNext = true;
        return this;
    }

    private void applySeparator() {
        if (this.separateNext) {
            this.builder.append("; ");
        }
        this.separateNext = false;
    }

    public OverpassFilterQuery node() {
        this.applySeparator();
        this.builder.append("node");
        return this;
    }

    public OverpassFilterQuery rel() {
        this.applySeparator();
        this.builder.append("rel");
        return this;
    }

    public OverpassFilterQuery way() {
        this.applySeparator();
        this.builder.append("way");
        return this;
    }

    public OverpassFilterQuery area() {
        this.applySeparator();
        this.builder.append("area");
        return this;
    }

    public OverpassFilterQuery amenity(String amenity) {
        this.builder.equals("amenity", amenity);
        return this;
    }

    public OverpassFilterQuery amenities(Set<String> amenities) {
        this.builder.multipleValues("amenity", amenities);
        return this;
    }

    public OverpassFilterQuery tag(String name) {
        this.builder.standaloneParam(name);
        return this;
    }

    public OverpassFilterQuery tag(String name, String value) {
        this.builder.equals(name, value);
        return this;
    }

    public OverpassFilterQuery tagMultiple(String name, Set<String> values) {
        this.builder.multipleValues(name, values);
        return this;
    }

    public OverpassFilterQuery tagNot(String name, String value) {
        this.builder.notEquals(name, value);
        return this;
    }

    public OverpassFilterQuery tagRegex(String name, String value) {
        this.builder.regexMatches(name, value);
        return this;
    }

    public OverpassFilterQuery tagRegexNot(String name, String value) {
        this.builder.regexDoesntMatch(name, value);
        return this;
    }

    public OverpassFilterQuery boundingBox(double southernLat, double westernLon, double northernLat, double easternLon) {
        this.builder.boundingBox(southernLat, westernLon, northernLat, easternLon);
        return this;
    }

    @Override
    public String build() {
        this.builder.append(";<;)");
        return this.builder.build();
    }
}

