/*
 * Decompiled with CFR 0.152.
 */
package hu.supercluster.overpasser.library.query;

import hu.supercluster.overpasser.library.output.OutputFormat;
import hu.supercluster.overpasser.library.output.OutputModificator;
import hu.supercluster.overpasser.library.output.OutputOrder;
import hu.supercluster.overpasser.library.output.OutputVerbosity;
import hu.supercluster.overpasser.library.query.AbstractOverpassQuery;
import hu.supercluster.overpasser.library.query.OverpassFilterQuery;
import hu.supercluster.overpasser.library.query.OverpassQueryBuilder;
import java.util.Locale;

public class OverpassQuery
extends AbstractOverpassQuery {
    public OverpassQuery() {
    }

    OverpassQuery(OverpassQueryBuilder builder) {
        super(builder);
    }

    public OverpassQuery format(OutputFormat outputFormat) {
        this.builder.clause("out", outputFormat.toString().toLowerCase());
        return this;
    }

    public OverpassQuery timeout(int timeout) {
        this.builder.clause("timeout", "" + timeout);
        return this;
    }

    public OverpassQuery boundingBox(double southernLat, double westernLon, double northernLat, double easternLon) {
        this.builder.append(String.format(Locale.US, "[bbox:%s,%s,%s,%s]", southernLat, westernLon, northernLat, easternLon));
        return this;
    }

    public OverpassFilterQuery filterQuery() {
        return new OverpassFilterQuery(this);
    }

    public OverpassQuery output(int limit) {
        return this.output(OutputVerbosity.BODY, OutputModificator.CENTER, OutputOrder.QT, limit);
    }

    public OverpassQuery output(OutputVerbosity verbosity, OutputModificator modificator, OutputOrder order, int limit) {
        this.builder.append(String.format("; out %s %s %s %s", verbosity.toString().toLowerCase(), modificator.toString().toLowerCase(), order.toString().toLowerCase(), limit));
        return this;
    }

    @Override
    public String build() {
        this.builder.append(";");
        return this.builder.build();
    }
}

