/*
 * Decompiled with CFR 0.152.
 */
package hu.supercluster.overpasser.library.query;

import hu.supercluster.overpasser.library.query.OverpassQueryBuilder;
import java.util.Locale;
import java.util.Set;

class OverpassQueryBuilderImpl
implements OverpassQueryBuilder {
    private static final Locale LOCALE = Locale.US;
    private StringBuilder builder = new StringBuilder();

    @Override
    public OverpassQueryBuilder append(String statement) {
        this.builder.append(statement);
        return this;
    }

    private OverpassQueryBuilder paramRel(String name, String rel, String value) {
        String quotedValue = value.isEmpty() ? "" : String.format("\"%s\"", value);
        return this.append(String.format(LOCALE, "[\"%s\"%s%s]", name, rel, quotedValue));
    }

    @Override
    public OverpassQueryBuilder boundingBox(double lat1, double lon1, double lat2, double lon2) {
        return this.append(String.format(LOCALE, "(%s,%s,%s,%s)", lat1, lon1, lat2, lon2));
    }

    @Override
    public OverpassQueryBuilder standaloneParam(String name) {
        return this.paramRel(name, "", "");
    }

    @Override
    public OverpassQueryBuilder clause(String name, String value) {
        return this.paramRel(name, ":", value);
    }

    @Override
    public OverpassQueryBuilder equals(String name, String value) {
        return this.paramRel(name, "=", value);
    }

    @Override
    public OverpassQueryBuilder notEquals(String name, String value) {
        return this.paramRel(name, "!=", value);
    }

    @Override
    public OverpassQueryBuilder regexMatches(String name, String value) {
        return this.paramRel(name, "~", value);
    }

    @Override
    public OverpassQueryBuilder regexDoesntMatch(String name, String value) {
        return this.paramRel(name, "!~", value);
    }

    @Override
    public OverpassQueryBuilder multipleValues(String name, Set<String> values) {
        StringBuilder joiner = new StringBuilder();
        for (String value : values) {
            joiner.append(value);
            joiner.append("|");
        }
        joiner.setLength(joiner.length() - 1);
        return this.paramRel(name, "~", joiner.toString());
    }

    @Override
    public String build() {
        return this.builder.toString();
    }
}

