/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.fs;

import hu.webarticum.treeprinter.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.fs.FsTreeNode;
import java.io.File;
import java.text.DecimalFormat;

public class DefaultFsTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    public DefaultFsTreeNodeDecorator(TreeNode decoratedNode) {
        super(decoratedNode);
    }

    public DefaultFsTreeNodeDecorator(TreeNode decoratedNode, boolean decorable) {
        super(decoratedNode, decorable);
    }

    public DefaultFsTreeNodeDecorator(TreeNode decoratedNode, boolean decorable, boolean inherit) {
        super(decoratedNode, decorable, inherit);
    }

    public DefaultFsTreeNodeDecorator(TreeNode decoratedNode, boolean decorable, boolean inherit, boolean forceInherit) {
        super(decoratedNode, decorable, inherit, forceInherit);
    }

    @Override
    public String getContent() {
        if (this.decoratedNode instanceof FsTreeNode) {
            FsTreeNode fsNode = (FsTreeNode)this.decoratedNode;
            File file = fsNode.getFile();
            if (file.isDirectory()) {
                return "(D) " + file.getName();
            }
            return file.getName() + " (" + this.formatFileSize(file.length()) + ")";
        }
        return this.decoratedNode.getContent();
    }

    @Override
    protected TreeNode decorateChild(TreeNode childNode) {
        return new DefaultFsTreeNodeDecorator(childNode, this.decorable, this.inherit, this.forceInherit);
    }

    protected String formatFileSize(long fileSize) {
        String[] suffixes = new String[]{" KB", " MB", " GB"};
        double floatingSize = fileSize;
        String suffix = " b";
        for (String _suffix : suffixes) {
            if (!(floatingSize > 850.0)) continue;
            floatingSize /= 1024.0;
            suffix = _suffix;
        }
        return new DecimalFormat("#.##").format(floatingSize) + suffix;
    }
}

