/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter.decorator;

import hu.webarticum.treeprinter.Insets;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.decorator.AbstractTreeNodeDecorator;
import hu.webarticum.treeprinter.util.Util;

public class BorderTreeNodeDecorator
extends AbstractTreeNodeDecorator {
    private static final char[] BORDER_CHARS_ASCII = new char[]{'.', '-', '.', '|', '\'', '-', '`', '|'};
    private static final char[] BORDER_CHARS_UNICODE = new char[]{'\u250c', '\u2500', '\u2510', '\u2502', '\u2518', '\u2500', '\u2514', '\u2502'};
    private static final char[] BORDER_CHARS_WIDE_UNICODE = new char[]{'\u259b', '\u2594', '\u259c', '\u2595', '\u259f', '\u2581', '\u2599', '\u258f'};
    private final char topLeft;
    private final char top;
    private final char topRight;
    private final char right;
    private final char bottomRight;
    private final char bottom;
    private final char bottomLeft;
    private final char left;

    public BorderTreeNodeDecorator(TreeNode baseNode) {
        this(baseNode, BorderTreeNodeDecorator.builder());
    }

    private BorderTreeNodeDecorator(TreeNode baseNode, Builder builder) {
        super(baseNode, builder.inherit, builder.decorable);
        this.topLeft = builder.characters[0];
        this.top = builder.characters[1];
        this.topRight = builder.characters[2];
        this.right = builder.characters[3];
        this.bottomRight = builder.characters[4];
        this.bottom = builder.characters[5];
        this.bottomLeft = builder.characters[6];
        this.left = builder.characters[7];
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String decoratedContent() {
        String content = this.baseNode.content();
        String[] contentLines = Util.splitToLines(content);
        int longestLineLength = Util.getMaxLength(contentLines);
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append(this.topLeft);
        Util.repeat(resultBuilder, this.top, longestLineLength);
        resultBuilder.append(this.topRight);
        resultBuilder.append('\n');
        for (String contentLine : contentLines) {
            resultBuilder.append(this.left);
            resultBuilder.append(contentLine);
            Util.repeat(resultBuilder, ' ', longestLineLength - contentLine.length());
            resultBuilder.append(this.right);
            resultBuilder.append('\n');
        }
        resultBuilder.append(this.bottomLeft);
        Util.repeat(resultBuilder, this.bottom, longestLineLength);
        resultBuilder.append(this.bottomRight);
        return resultBuilder.toString();
    }

    @Override
    public Insets insets() {
        return this.baseNode.insets().extendedWith(1);
    }

    @Override
    protected TreeNode wrapChild(TreeNode childNode, int index) {
        return BorderTreeNodeDecorator.builder().decorable(this.decorable).inherit(this.inherit).topLeft(this.topLeft).top(this.top).topRight(this.topRight).right(this.right).bottomRight(this.bottomRight).bottom(this.bottom).bottomLeft(this.bottomLeft).left(this.left).buildFor(childNode);
    }

    public static class Builder {
        private boolean inherit = true;
        private boolean decorable = true;
        private char[] characters = UnicodeMode.isUnicodeDefault() ? (char[])BorderTreeNodeDecorator.access$300().clone() : (char[])BorderTreeNodeDecorator.access$400().clone();

        public Builder inherit(boolean inherit) {
            this.inherit = inherit;
            return this;
        }

        public Builder decorable(boolean decorable) {
            this.decorable = decorable;
            return this;
        }

        public Builder ascii() {
            this.characters = (char[])BORDER_CHARS_ASCII.clone();
            return this;
        }

        public Builder unicode() {
            this.characters = (char[])BORDER_CHARS_UNICODE.clone();
            return this;
        }

        public Builder wideUnicode() {
            this.characters = (char[])BORDER_CHARS_WIDE_UNICODE.clone();
            return this;
        }

        public Builder topLeft(char topLeft) {
            this.characters[0] = topLeft;
            return this;
        }

        public Builder top(char top) {
            this.characters[1] = top;
            return this;
        }

        public Builder topRight(char topRight) {
            this.characters[2] = topRight;
            return this;
        }

        public Builder right(char right) {
            this.characters[3] = right;
            return this;
        }

        public Builder bottomRight(char bottomRight) {
            this.characters[4] = bottomRight;
            return this;
        }

        public Builder bottom(char bottom) {
            this.characters[5] = bottom;
            return this;
        }

        public Builder bottomLeft(char bottomLeft) {
            this.characters[6] = bottomLeft;
            return this;
        }

        public Builder left(char left) {
            this.characters[7] = left;
            return this;
        }

        public BorderTreeNodeDecorator buildFor(TreeNode node) {
            return new BorderTreeNodeDecorator(node, this);
        }
    }
}

